/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.JavadocTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class JavadocImpl
implements Javadoc {
    private String text;
    private final List<JavadocTag> tags;

    public JavadocImpl() {
        this.text = "";
        this.tags = new ArrayList<JavadocTag>();
    }

    public JavadocImpl(String text) {
        this.text = Objects.requireNonNull(text);
        this.tags = new ArrayList<JavadocTag>();
    }

    protected JavadocImpl(Javadoc prototype) {
        this.text = Objects.requireNonNull(prototype).getText();
        this.tags = Copier.copy(prototype.getTags());
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Javadoc setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public List<JavadocTag> getTags() {
        return this.tags;
    }

    @Override
    public JavadocImpl copy() {
        return new JavadocImpl(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.text);
        hash = 29 * hash + Objects.hashCode(this.tags);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavadocImpl other = (JavadocImpl)obj;
        if (!Objects.equals(this.text, other.text)) {
            return false;
        }
        return Objects.equals(this.tags, other.tags);
    }
}

