/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.JavadocTagImpl;
import com.speedment.common.codegen.model.JavadocTag;
import java.util.Objects;
import java.util.Optional;

abstract class JavadocTagBase
implements JavadocTag {
    private String name;
    private String value;
    private String text;

    JavadocTagBase(String name) {
        this.name = Objects.requireNonNull(name);
        this.value = null;
        this.text = null;
    }

    JavadocTagBase(String name, String text) {
        this.name = Objects.requireNonNull(name);
        this.value = null;
        this.text = text;
    }

    JavadocTagBase(String name, String value, String text) {
        this.name = Objects.requireNonNull(name);
        this.value = value;
        this.text = text;
    }

    JavadocTagBase(JavadocTag prototype) {
        Objects.requireNonNull(prototype);
        this.name = prototype.getName();
        this.value = prototype.getValue().orElse(null);
        this.text = prototype.getText().orElse(null);
    }

    @Override
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public JavadocTag setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    public JavadocTag setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public JavadocTag setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JavadocTagImpl copy() {
        return new JavadocTagImpl(this);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.name);
        hash = 67 * hash + Objects.hashCode(this.value);
        hash = 67 * hash + Objects.hashCode(this.text);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavadocTagBase other = (JavadocTagBase)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        return Objects.equals(this.text, other.text);
    }
}

