/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.util;

import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.internal.util.StaticClassUtil;
import com.speedment.common.codegen.util.Formatting;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TextUtil {
    private static final Pattern WORDS = Pattern.compile("[\\s]+");
    private static final Pattern JAVADOC_WORDS = Pattern.compile("[ ]+");
    private static final String NL = "\n";
    private static final int JAVA_DOC_WIDTH = 74;
    private static final Set<String> JAVA_DOC_SINGLE_LINE_WORDS = Collections.unmodifiableSet(Stream.of("<p>").collect(Collectors.toSet()));

    public static Stream<String> wordsOf(String text) {
        Objects.requireNonNull(text);
        return WORDS.splitAsStream(text);
    }

    public static String formatTextBox(String text, int width) {
        Objects.requireNonNull(text);
        return TextUtil.formatTextBox(text, width, WORDS, Collections.emptySet());
    }

    public static String formatTextBox(String text, int width, Pattern splitter, Set<String> singleRowers) {
        NullUtil.requireNonNulls(text, splitter);
        NullUtil.requireNonNullElements(singleRowers);
        StringBuilder sb = new StringBuilder();
        AtomicInteger col = new AtomicInteger();
        splitter.splitAsStream(text).map(w -> w.replace("\t", Formatting.tab())).forEachOrdered(w -> {
            int wordLen = w.length() - Math.max(w.lastIndexOf(NL), 0);
            if (singleRowers.contains(w)) {
                sb.append(NL);
                sb.append((String)w);
                sb.append(NL);
                col.set(0);
            } else {
                if (col.get() + wordLen >= width) {
                    sb.append(NL);
                    col.set(0);
                } else if (col.get() > 0) {
                    sb.append(" ");
                    col.incrementAndGet();
                }
                sb.append((String)w);
                col.getAndAdd(wordLen);
            }
        });
        return sb.toString();
    }

    public static String formatJavaDocBox(String text) {
        Objects.requireNonNull(text);
        return TextUtil.formatTextBox(text, 74, JAVADOC_WORDS, JAVA_DOC_SINGLE_LINE_WORDS);
    }

    public static String alignCenter(String substring, int totalWidth) {
        return TextUtil.alignCenter(substring, totalWidth, ' ');
    }

    public static String alignCenter(String substring, int totalWidth, char fill) {
        if (substring.length() > totalWidth) {
            return substring.substring(0, totalWidth);
        }
        double padding = (double)(totalWidth - substring.length()) / 2.0;
        int left = (int)Math.floor(padding);
        int right = (int)Math.ceil(padding);
        return TextUtil.repeat("" + fill, left) + substring + TextUtil.repeat("" + fill, right);
    }

    public static String alignLeft(String substring, int totalWidth) {
        return TextUtil.alignLeft(substring, totalWidth, ' ');
    }

    public static String alignLeft(String substring, int totalWidth, char fill) {
        if (substring.length() > totalWidth) {
            return substring.substring(0, totalWidth);
        }
        return substring + TextUtil.repeat("" + fill, totalWidth - substring.length());
    }

    public static String alignRight(String substring, int totalWidth) {
        return TextUtil.alignRight(substring, totalWidth, ' ');
    }

    public static String alignRight(String substring, int totalWidth, char fill) {
        if (substring.length() > totalWidth) {
            return substring.substring(0, totalWidth);
        }
        return TextUtil.repeat("" + fill, totalWidth - substring.length()) + substring;
    }

    public static String repeat(String str, int count) {
        StringBuilder result = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    private TextUtil() {
        StaticClassUtil.instanceNotAllowed(this.getClass());
    }
}

