/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.util;

import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.internal.util.StaticClassUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Formatting {
    private static String nl = "\n";
    private static String dnl = "\n\n";
    private static String indent = "    ";

    public static String separate(String separator, String ... blocks) {
        NullUtil.requireNonNullElements(blocks);
        return Stream.of(blocks).collect(Collectors.joining(separator));
    }

    public static String lcfirst(String input) {
        return Formatting.withFirst(input, first -> String.valueOf(Character.toLowerCase(first.charValue())));
    }

    public static String ucfirst(String input) {
        return Formatting.withFirst(input, first -> String.valueOf(Character.toUpperCase(first.charValue())));
    }

    public static String withFirst(String input, Function<Character, String> callback) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return "";
        }
        return String.join((CharSequence)"", callback.apply(Character.valueOf(input.charAt(0))), input.subSequence(1, input.length()));
    }

    public static String repeat(String str, int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    public static String block(String text) {
        return "{" + nl + Formatting.indent(text) + nl + "}";
    }

    public static String block(String row, String ... rows) {
        Objects.requireNonNull(row);
        NullUtil.requireNonNullElements(rows);
        return Formatting.block(Arrays.stream(rows).collect(Collectors.joining(Formatting.nl(), row + Formatting.nl(), "")));
    }

    public static String block(Stream<String> rows) {
        return Formatting.block(rows.collect(Collectors.joining(Formatting.nl())));
    }

    public static String indent(String text) {
        return indent + text.replaceAll("\\r?\\n", nl + indent);
    }

    public static String indent(String ... text) {
        return indent + String.join((CharSequence)Formatting.nl(), text).replaceAll("\\r?\\n", nl + indent);
    }

    public static String indent(Stream<String> text) {
        return Formatting.indent((String[])text.toArray(String[]::new));
    }

    public static String indent(String text, int steps) {
        switch (steps) {
            case 0: {
                return text;
            }
            case 1: {
                return Formatting.indent(text);
            }
        }
        return Formatting.indent(Formatting.indent(text, steps - 1));
    }

    public static <E, R> R ifelse(Optional<E> condition, Function<E, R> trueMap, R falseValue) {
        if (condition.isPresent()) {
            return trueMap.apply(condition.get());
        }
        return falseValue;
    }

    public static String nl() {
        return nl;
    }

    public static void nl(String nl) {
        Formatting.nl = nl;
        dnl = nl + nl;
    }

    public static String dnl() {
        return dnl;
    }

    public static String tab() {
        return indent;
    }

    public static void tab(String tab) {
        indent = tab;
    }

    public static String shortName(String longName) {
        String temp = longName.replace('$', '.');
        if (temp.contains(".")) {
            return temp.substring(temp.lastIndexOf(".") + 1);
        }
        return temp;
    }

    public static Optional<String> packageName(String longName) {
        if (longName.contains(".")) {
            return Optional.of(longName.substring(0, longName.lastIndexOf(".")));
        }
        return Optional.empty();
    }

    public static Optional<String> fileToClassName(String fileName) {
        Optional<String> result = Optional.empty();
        if (fileName.endsWith(".java")) {
            String className = fileName;
            className = className.replace('/', '.');
            className = className.replace('\\', '.');
            className = className.substring(0, className.length() - 5);
            result = Optional.of(className);
        }
        return result;
    }

    public static String classToJavaFileName(String longName) {
        return longName.replace('.', '/') + ".java";
    }

    public static String stripGenerics(String className) {
        String name = className;
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf("<"));
        }
        if (name.contains("[")) {
            name = name.substring(0, name.indexOf("["));
        }
        return name;
    }

    public static String alignTabs(String rows) {
        List<String> list = Stream.of(rows.split(Formatting.nl())).collect(Collectors.toList());
        Formatting.alignTabs(list);
        return list.stream().collect(Collectors.joining(Formatting.nl()));
    }

    public static void alignTabs(List<String> rows) {
        block0: while (true) {
            int index;
            int maxIndex = -1;
            for (String row : rows) {
                index = row.indexOf(9);
                if (index <= maxIndex) continue;
                maxIndex = index;
            }
            if (maxIndex <= -1) break;
            int i = 0;
            while (true) {
                String row;
                if (i >= rows.size()) continue block0;
                row = rows.get(i);
                index = row.indexOf(9);
                if (index > -1) {
                    rows.set(i, row.replaceFirst("\t", Formatting.repeat(" ", maxIndex - index)));
                }
                ++i;
            }
            break;
        }
    }

    private Formatting() {
        StaticClassUtil.instanceNotAllowed(this.getClass());
    }
}

