/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal;

import com.github.pyknic.bigarray.ByteImmutableArray;
import com.github.pyknic.bigarray.IntImmutableArray;
import com.github.pyknic.bigarray.ShortImmutableArray;
import com.github.pyknic.bigarray.internal.EmptyImmutableArray;
import com.github.pyknic.bigarray.internal.IntImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.IntMultiBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.IntSingleBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.util.BitUtil;
import com.github.pyknic.bigarray.internal.util.IndexUtil;
import com.github.pyknic.bigarray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.function.IntConsumer;

public final class IntImmutableArrayBuilder
implements IntImmutableArray.Builder {
    private final LinkedList<IntBuffer> buffers = new LinkedList();
    private int bitmask;
    private int outer = 0;
    private int inner = 0;

    @Override
    public IntImmutableArray.Builder append(int value) {
        IntBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x10000000).asIntBuffer();
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        current.put(this.inner, value);
        this.bitmask |= value;
        if (0x4000000 == ++this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (BitUtil.isLongToBytePossible(this.bitmask)) {
            ByteImmutableArray.Builder builder = ByteImmutableArray.builder();
            this.forEachThenClear(value -> builder.append(BitUtil.intToByte(value)));
            this.buffers.forEach(MemoryUtil::clear);
            return (IntImmutableArray)((Object)builder.build());
        }
        if (BitUtil.isLongToShortPossible(this.bitmask)) {
            ShortImmutableArray.Builder builder = ShortImmutableArray.builder();
            this.forEachThenClear(value -> builder.append(BitUtil.intToShort(value)));
            this.buffers.forEach(MemoryUtil::clear);
            return (IntImmutableArray)((Object)builder.build());
        }
        if (this.outer == 0) {
            IntBuffer current = this.buffers.getFirst();
            if (this.inner < Short.MAX_VALUE) {
                try {
                    int[] array = new int[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    IntImmutableArrayImpl intImmutableArrayImpl = new IntImmutableArrayImpl(array);
                    return intImmutableArrayImpl;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            return new IntSingleBufferImmutableArrayImpl(current, this.inner);
        }
        return new IntMultiBufferImmutableArrayImpl(this.bufferArray(), this.length());
    }

    private long length() {
        return this.outer * 0x4000000 + this.inner;
    }

    private IntBuffer[] bufferArray() {
        return this.buffers.toArray(new IntBuffer[this.outer + 1]);
    }

    private void forEachThenClear(IntConsumer action) {
        long length = this.length();
        IntBuffer[] bufferArray = this.bufferArray();
        for (long l = 0L; l < length; ++l) {
            int o = IndexUtil.outerIndex(l);
            int i = IndexUtil.innerIndex(l);
            action.accept(bufferArray[o].get(i));
            if (i + 1 != 0x4000000) continue;
            MemoryUtil.clear(bufferArray[o]);
        }
    }
}

