/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal.booleans;

import com.github.pyknic.bigarray.BooleanImmutableArray;
import com.github.pyknic.bigarray.internal.util.BitUtil;
import java.nio.ShortBuffer;

public final class BooleanLargeImmutableArray
implements BooleanImmutableArray {
    private final ShortBuffer buffer;
    private final long length;

    public BooleanLargeImmutableArray(ShortBuffer buffer, long length) {
        this.buffer = buffer;
        this.length = length;
    }

    @Override
    public boolean getAsBoolean(long index) {
        short bitmask = this.buffer.get((int)(index / 16L));
        return BitUtil.isSet(bitmask, index % 16L);
    }

    @Override
    public long length() {
        return this.length;
    }
}

