/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.data_source;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qa.automation.utils.java.utils.common.FileOprs;
import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.data_source.XlsxWorkbook;
import com.qa.automation.utils.java.utils.exception.GenericRuntimeException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.ExtendedColor;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class DataSource {
    private String filePath;
    private String directoryPath;
    private String fileName;
    private String fileExtension;
    private String fileCopyPath;
    private String sheetName;
    private ArrayList<String> filteredColumnNameList = new ArrayList();
    private ArrayList<String> fullColumnNameList = new ArrayList();
    private ArrayList<String> fullPropertyList = new ArrayList();
    private ArrayList<String> filteredPropertyList = new ArrayList();
    private JsonObject filteredDataValues = new JsonObject();
    private JsonObject fullDataValues = new JsonObject();
    private JsonObject dataAddresses = new JsonObject();
    private Object[] filteredKeyList;
    private Object[] fullKeyList;
    private DataFormatter dataFormatter = new DataFormatter();
    private Workbook workbook = null;
    private JsonObject filteredDataValueJsonObject;
    private JsonObject fullDataValueJsonObject;
    private JsonObject dataAddressJsonObject;
    private JsonArray cellAddressJsonArray;

    public DataSource(String filePath, String sheetName) {
        FileOprs fileOprs = new FileOprs();
        this.tryFindDataSourceFileAndReturnPath(filePath);
        this.directoryPath = fileOprs.getDirectoryPathFromFilePath(filePath);
        this.fileName = fileOprs.getFileNameWithoutExtensionFromFilePath(filePath);
        this.fileExtension = fileOprs.getFileExtensionFromFilePath(filePath);
        this.fileCopyPath = this.directoryPath + this.fileName + "_copy" + "." + this.fileExtension;
        this.sheetName = sheetName;
        this.loadData();
        if (this.filteredDataValues.size() > 0) {
            this.filteredKeyList = this.filteredDataValues.keySet().toArray();
        }
        if (this.fullDataValues.size() > 0) {
            this.fullKeyList = this.fullDataValues.keySet().toArray();
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFileCopyPath() {
        return this.fileCopyPath;
    }

    public void createFileCopy() {
        new FileOprs().copyFile(this.filePath, this.fileCopyPath);
    }

    public List<String> getFilteredColumnNameList() {
        return this.filteredColumnNameList;
    }

    public List<String> getFullColumnNameList() {
        return this.fullColumnNameList;
    }

    public List<String> getFilteredPropertyList() {
        return this.filteredPropertyList;
    }

    public List<String> getFullPropertyList() {
        return this.fullPropertyList;
    }

    public JsonObject getFilteredDataValues() {
        return this.filteredDataValues;
    }

    public JsonObject getFullDataValues() {
        return this.fullDataValues;
    }

    public JsonObject getDataAddresses() {
        return this.dataAddresses;
    }

    public JsonArray getDataAddress(String key, String property) {
        return this.dataAddresses.get(key).getAsJsonObject().get(property).getAsJsonArray();
    }

    public List<Object> getFilteredKeyList() {
        return Arrays.asList(this.filteredKeyList);
    }

    public List<Object> getFullKeyList() {
        return Arrays.asList(this.fullKeyList);
    }

    public int getDataRowIndex(String key, String property) {
        return this.getDataAddress(key, property).get(0).getAsInt();
    }

    public int getDataColumnIndex(String key, String property) {
        return this.getDataAddress(key, property).get(1).getAsInt();
    }

    public JsonObject getDataItemFromFilteredDataValues(String key) {
        return this.filteredDataValues.getAsJsonObject(key);
    }

    public JsonObject getDataItemFromFullDataValues(String key) {
        return this.fullDataValues.getAsJsonObject(key);
    }

    public Cell getCell(int rowIndex, int columnIndex) {
        return this.workbook != null ? this.workbook.getSheet(this.sheetName).getRow(rowIndex).getCell(columnIndex) : null;
    }

    public Cell getCell(String key, String property) {
        return this.getCell(this.getDataRowIndex(key, property), this.getDataColumnIndex(key, property));
    }

    public void setDataValue(String key, String property, String value) {
        Cell cell = this.getCell(key, property);
        cell.setCellStyle(this.getCell(this.getDataRowIndex(key, property), 0).getCellStyle());
        cell.setCellValue(value);
    }

    public void setDataValue(String key, String property, JsonElement value) {
        if (value.isJsonArray()) {
            this.setDataValue(key, property, value.getAsJsonArray().toString());
        } else {
            this.setDataValue(key, property, value.getAsString());
        }
    }

    private void saveDataSource(String filePath) {
        if (this.workbook != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(filePath);
                this.workbook.write((OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception e) {
                throw new GenericRuntimeException(e);
            }
        }
    }

    public void saveDataSource() {
        this.saveDataSource(this.filePath);
    }

    public void saveDataSourceCopy() {
        this.saveDataSource(this.fileCopyPath);
    }

    private String getCellFillColorCode(Cell cell) {
        String colorCode;
        try {
            colorCode = ((ExtendedColor)cell.getCellStyle().getFillForegroundColorColor()).getARGBHex();
        }
        catch (Exception e) {
            colorCode = null;
        }
        return colorCode;
    }

    private boolean cellFillColorCodeIsWhite(Cell cell) {
        String cellFillColorCode = this.getCellFillColorCode(cell);
        return cellFillColorCode == null || cellFillColorCode.equalsIgnoreCase("FFFFFFFF");
    }

    private void buildColumnNameListObjects(Row headerRow, Iterator<Row> iterator) {
        for (Cell headerCell : headerRow) {
            String headerCellValue = headerCell.getStringCellValue().trim();
            this.checkIfHeaderCellValueIsDuplicated(headerCellValue);
            if (this.dataFormatter.formatCellValue(headerCell).trim().equals("")) continue;
            if (this.cellFillColorCodeIsWhite(headerCell)) {
                if (headerCell.getColumnIndex() > 0) {
                    this.filteredPropertyList.add(headerCellValue);
                }
                this.filteredColumnNameList.add(headerCellValue);
            }
            if (headerCell.getColumnIndex() > 0) {
                this.fullPropertyList.add(headerCellValue);
            }
            this.fullColumnNameList.add(headerCellValue);
        }
        if (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void checkIfHeaderCellValueIsDuplicated(String headerCellValue) {
        if (this.fullColumnNameList.contains(headerCellValue)) {
            throw new GenericRuntimeException("The header cell value <" + headerCellValue + "> is duplicated in the sheet <" + this.sheetName + "> of the data source file <" + this.filePath + ">");
        }
    }

    private void buildDataValueSubObjects(Cell propertyCell, String property, Cell valueCell, String value, int rowIndex, int columnIndex) {
        if (!this.dataFormatter.formatCellValue(propertyCell).trim().equals("")) {
            if (this.cellFillColorCodeIsWhite(propertyCell) && this.cellFillColorCodeIsWhite(valueCell)) {
                this.filteredDataValueJsonObject.addProperty(property, value);
            }
            this.fullDataValueJsonObject.addProperty(property, value);
            this.cellAddressJsonArray.add((Number)rowIndex);
            this.cellAddressJsonArray.add((Number)columnIndex);
            this.dataAddressJsonObject.add(property, (JsonElement)this.cellAddressJsonArray);
        }
    }

    private void buildDataValueObjects(Cell rowKeyCell, String rowKeyValue, JsonObject filteredDataValueJsonObject, JsonObject fullDataValueJsonObject, JsonObject dataAddressJsonObject) {
        if (rowKeyValue != null && !rowKeyValue.equals("")) {
            if (this.fullDataValues.has(rowKeyValue)) {
                throw new GenericRuntimeException("The row key <" + rowKeyValue + "> is duplicated in the sheet <" + this.sheetName + "> of the data source file <" + this.filePath + ">");
            }
            if (this.cellFillColorCodeIsWhite(rowKeyCell)) {
                this.filteredDataValues.add(rowKeyValue, (JsonElement)filteredDataValueJsonObject);
            }
            this.fullDataValues.add(rowKeyValue, (JsonElement)fullDataValueJsonObject);
            this.dataAddresses.add(rowKeyValue, (JsonElement)dataAddressJsonObject);
        }
    }

    private void loadData() {
        this.workbook = new XlsxWorkbook(this.filePath).getWorkbook();
        Sheet sheet = this.workbook.getSheet(this.sheetName);
        Iterator iterator = sheet.iterator();
        Row headerRow = sheet.getRow(0);
        int lastCellNum = headerRow.getLastCellNum();
        this.buildColumnNameListObjects(headerRow, iterator);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            int rowIndex = row.getRowNum();
            this.filteredDataValueJsonObject = new JsonObject();
            this.fullDataValueJsonObject = new JsonObject();
            this.dataAddressJsonObject = new JsonObject();
            Cell rowKeyCell = null;
            String rowKeyValue = null;
            String property = null;
            for (int i = 0; i < lastCellNum; ++i) {
                Cell cell = row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                this.cellAddressJsonArray = new JsonArray();
                int columnIndex = cell.getColumnIndex();
                if (columnIndex == 0) {
                    rowKeyCell = cell;
                    rowKeyValue = this.dataFormatter.formatCellValue(rowKeyCell).trim();
                    continue;
                }
                Cell propertyCell = headerRow.getCell(columnIndex);
                property = this.dataFormatter.formatCellValue(propertyCell).trim();
                Cell valueCell = cell;
                String value = this.dataFormatter.formatCellValue(valueCell).trim();
                this.buildDataValueSubObjects(propertyCell, property, valueCell, value, rowIndex, columnIndex);
            }
            this.buildDataValueObjects(rowKeyCell, rowKeyValue, this.filteredDataValueJsonObject, this.fullDataValueJsonObject, this.dataAddressJsonObject);
        }
    }

    private void tryFindDataSourceFileAndReturnPath(String filePath) {
        String foundFilePath = new FileOprs().tryFindFileAndReturnPath(filePath);
        if (new StringOprs().isEmptyOrNull(foundFilePath)) {
            throw new GenericRuntimeException("The data source file <" + filePath + "> was not found");
        }
        this.filePath = foundFilePath;
    }
}

