/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.params;

import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.exception.GenericRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;

public class ProjectConfigProperties {
    private static final String PROJECT_CONFIG_PROPERTIES_FILE_NAME = "project.config.properties";
    private static final String MAIN_RESOURCES_DIRECTORY_PATH = "src/main/resources/";
    private static final String TEST_RESOURCES_DIRECTORY_PATH = "src/test/resources/";
    private static Properties properties = null;
    private static StringOprs stringOprs = new StringOprs();

    private ProjectConfigProperties() {
    }

    public static void addConfigPropertiesFile(String configPropertiesFilePath) {
        try {
            File configPropertiesFileObject = new File(configPropertiesFilePath);
            ProjectConfigProperties.addConfigPropertiesFile(configPropertiesFileObject);
        }
        catch (Exception e) {
            throw new GenericRuntimeException("Could not load project configuration properties file");
        }
    }

    public static void addConfigPropertiesFile(File configPropertiesFileObject) {
        if (properties == null) {
            properties = new Properties();
        }
        try (FileInputStream inputStream = new FileInputStream(configPropertiesFileObject);){
            Properties properties = new Properties();
            properties.load(inputStream);
            ProjectConfigProperties.properties.putAll((Map<?, ?>)properties);
        }
        catch (Exception e) {
            throw new GenericRuntimeException("Could not load project configuration properties file");
        }
    }

    public static void setProperty(String key, String value) {
        if (!stringOprs.isEmptyOrNull(key)) {
            key = key.trim();
        }
        if (!stringOprs.isEmptyOrNull(value)) {
            value = value.trim();
        }
        if (properties != null) {
            properties.setProperty(key, value);
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getAsString(String key) {
        String value;
        if (!stringOprs.isEmptyOrNull(key)) {
            key = key.trim();
        }
        String string = value = properties == null ? null : properties.getProperty(key, "");
        if (stringOprs.isEmptyOrNull(value)) {
            throw new GenericRuntimeException("The project configuration parameter <" + key + "> does not exist");
        }
        return value == null ? null : value.trim();
    }

    public static Boolean getAsBoolean(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Boolean.parseBoolean(value);
    }

    public static int getAsInteger(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Integer.parseInt(value);
    }

    public static double getAsDouble(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Double.parseDouble(value);
    }

    public static long getAsLong(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Long.parseLong(value);
    }

    public static float getAsFloat(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Float.parseFloat(value);
    }

    public static byte getAsByte(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Byte.parseByte(value);
    }

    public static short getAsShort(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Short.parseShort(value);
    }

    static {
        File file = new File("src/main/resources/project.config.properties");
        if (!file.exists()) {
            file = new File("src/test/resources/project.config.properties");
        }
        ProjectConfigProperties.addConfigPropertiesFile(file);
    }
}

