/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.common;

import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.params.CommonParams;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileOprs
extends FileUtils {
    public String addBackslashToEndOfDirectoryPath(String directoryPath) {
        StringOprs stringOprs = new StringOprs();
        if (!stringOprs.isEmptyOrNull(directoryPath) && !directoryPath.endsWith(CommonParams.PATH_SEPARATOR_CHAR)) {
            directoryPath = directoryPath + CommonParams.PATH_SEPARATOR_CHAR;
        }
        return directoryPath;
    }

    public String removeBackslashToEndOfDirectoryPath(String directoryPath) {
        StringOprs stringOprs = new StringOprs();
        if (!stringOprs.isEmptyOrNull(directoryPath) && directoryPath.endsWith(CommonParams.PATH_SEPARATOR_CHAR)) {
            directoryPath = directoryPath.substring(0, directoryPath.lastIndexOf(CommonParams.PATH_SEPARATOR_CHAR));
        }
        return directoryPath;
    }

    public String findFileBackwardsAndGetAbsoluteFilePath(String pivotDirectoryPath, String fileName) {
        StringOprs stringOprs = new StringOprs();
        String absoluteFilePath = null;
        if (!stringOprs.isEmptyOrNull(pivotDirectoryPath) && !stringOprs.isEmptyOrNull(fileName)) {
            while (!stringOprs.isEmptyOrNull(pivotDirectoryPath)) {
                if (this.existsFile(this.normalizePath(pivotDirectoryPath, fileName))) {
                    if (this.isDirectory(fileName)) {
                        absoluteFilePath = this.addBackslashToEndOfDirectoryPath(this.normalizePath(pivotDirectoryPath, fileName));
                        break;
                    }
                    absoluteFilePath = this.normalizePath(pivotDirectoryPath, fileName);
                    break;
                }
                pivotDirectoryPath = this.getParentDirectoryPathFromFilePath(pivotDirectoryPath);
            }
        }
        return absoluteFilePath;
    }

    public String findFileInThisProjectAndGetAbsoluteFilePath(String fileNameWithExtension) {
        return this.findFileAndGetAbsoluteFilePath(System.getProperty("user.dir"), fileNameWithExtension);
    }

    public String findFileAndGetAbsoluteFilePath(String searchDirectoryPath, String fileNameWithExtension) {
        StringOprs stringOprs = new StringOprs();
        String subdirectory = this.getDirectoryPathFromFilePath(fileNameWithExtension);
        fileNameWithExtension = this.getFileNameWithExtensionFromFilePath(fileNameWithExtension);
        String absoluteFilePath = null;
        if (searchDirectoryPath != null) {
            File sourceDirectoryFile = new File(searchDirectoryPath);
            try {
                Collection files = FileUtils.listFiles((File)sourceDirectoryFile, null, (boolean)true);
                for (File file : files) {
                    if (!file.getName().equals(fileNameWithExtension)) continue;
                    absoluteFilePath = file.getAbsolutePath();
                    if (!stringOprs.isEmptyOrNull(subdirectory) && !absoluteFilePath.contains(this.normalizePath(subdirectory, fileNameWithExtension))) {
                        absoluteFilePath = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return absoluteFilePath;
    }

    public String findDirectoryAndGetAbsoluteDirectoryPath(String searchDirectoryPath, String directoryName) {
        StringOprs stringOprs = new StringOprs();
        String subdirectory = this.getDirectoryPathFromFilePath(directoryName);
        directoryName = this.getFileNameWithExtensionFromFilePath(directoryName);
        String absoluteDirectoryPath = null;
        if (searchDirectoryPath != null) {
            File sourceDirectoryFile = new File(searchDirectoryPath);
            try {
                Collection files = FileUtils.listFilesAndDirs((File)sourceDirectoryFile, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
                for (File file : files) {
                    if (!file.getName().equals(directoryName)) continue;
                    absoluteDirectoryPath = file.getAbsolutePath();
                    if (!stringOprs.isEmptyOrNull(subdirectory) && !absoluteDirectoryPath.contains(this.removeBackslashToEndOfDirectoryPath(this.normalizePath(subdirectory, directoryName)))) {
                        absoluteDirectoryPath = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return absoluteDirectoryPath;
    }

    public String getFileContent(String filePath) {
        File file = new File(filePath);
        try {
            return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFileContent(String filePath, Charset encoding) {
        File file = new File(filePath);
        try {
            return FileUtils.readFileToString((File)file, (Charset)encoding);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFileContent(String filePath, String encoding) {
        File file = new File(filePath);
        try {
            return FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String replaceStringInFileContent(String filePath, String regex, String replacement, String encoding) {
        return this.getFileContent(filePath, encoding).replaceAll(regex, replacement);
    }

    public String replaceStringInFileContent(String filePath, String regex, String replacement, Charset encoding) {
        return this.getFileContent(filePath, encoding).replaceAll(regex, replacement);
    }

    public String replaceStringInFileContent(String filePath, String regex, String replacement) {
        return this.getFileContent(filePath).replaceAll(regex, replacement);
    }

    public void writeFileContent(String filePath, String content) {
        this.writeFileContent(filePath, content, false);
    }

    public void writeFileContent(String filePath, String content, boolean append) {
        try {
            File file = new File(filePath);
            this.createParentDirectory(filePath);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, append));
            bufferedWriter.write(content);
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedWriter = null;
            file = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String normalizePath(String leftPath, String rightPath) {
        Path path = Paths.get(leftPath + CommonParams.PATH_SEPARATOR_CHAR + rightPath, new String[0]);
        String filePath = path.normalize().toString();
        if (this.existsFile(filePath)) {
            if (this.isDirectory(filePath)) {
                filePath = this.addBackslashToEndOfDirectoryPath(filePath);
            }
        } else if (this.checkIfPathStringIsDirectoryPath(filePath)) {
            filePath = this.addBackslashToEndOfDirectoryPath(filePath);
        }
        return filePath;
    }

    public boolean compareFiles(String filePath01, String filePath02) {
        try {
            File file01 = new File(filePath01);
            File file02 = new File(filePath02);
            return FileUtils.contentEquals((File)file01, (File)file02);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean existsFile(String filePath) {
        try {
            File file = new File(filePath);
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String checkIfExistsFileAndGetAbsolutePath(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void createDirectory(String directoryPath) {
        File file = new File(directoryPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = null;
    }

    public void createParentDirectory(String filePath) {
        File file = new File(filePath);
        this.createDirectory(file.getParent());
        file = null;
    }

    public void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile()) {
            file.delete();
        } else {
            System.out.println("File type is not file");
        }
    }

    public boolean isDirectory(String directoryPath) {
        File file = new File(directoryPath);
        return file.isDirectory();
    }

    public boolean isDirectoryEmpty(String directoryPath) {
        File file = new File(directoryPath);
        return file.list().length == 0;
    }

    public boolean checkIfPathStringIsDirectoryPath(String directoryPathString) {
        return !this.checkIfPathStringIsFilePath(directoryPathString);
    }

    public boolean isFile(String filePath) {
        File file = new File(filePath);
        return file.isFile();
    }

    public boolean checkIfPathStringIsFilePath(String filePathString) {
        String regex = "(.+)(:" + CommonParams.PATH_SEPARATOR_CHAR + CommonParams.PATH_SEPARATOR_CHAR + ")?(.+)(\\.)([^" + CommonParams.PATH_SEPARATOR_CHAR + CommonParams.PATH_SEPARATOR_CHAR + "]+)";
        return new StringOprs().evaluateRegex(regex, filePathString, false);
    }

    public void deleteDirectory(String directoryPath) {
        try {
            File file = new File(directoryPath);
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            } else {
                System.out.println("File type is not directory");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyDirectory(String sourceDirectoryPath, String destDirectoryPath) {
        try {
            File sourceFile = new File(sourceDirectoryPath);
            File destFile = new File(destDirectoryPath);
            FileUtils.copyDirectory((File)sourceFile, (File)destFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cutDirectory(String sourceDirectoryPath, String destDirectoryPath) {
        this.copyDirectory(sourceDirectoryPath, destDirectoryPath);
        this.deleteDirectory(sourceDirectoryPath);
    }

    public void copyAllDirectoryFilesToDirectory(String sourceFilePath, String destDirectoryPath) {
        try {
            File[] sourceFileList;
            File sourceFile = new File(sourceFilePath);
            File destFile = new File(destDirectoryPath);
            if (sourceFile.isFile()) {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)destFile);
                return;
            }
            for (File srcFile : sourceFileList = sourceFile.listFiles()) {
                if (srcFile.isFile()) {
                    FileUtils.copyFileToDirectory((File)srcFile, (File)destFile);
                    continue;
                }
                FileUtils.copyDirectory((File)srcFile, (File)new File(this.normalizePath(destDirectoryPath, srcFile.getName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyFile(String sourceFilePath, String destFilePath) {
        try {
            if (new File(destFilePath).isDirectory()) {
                String fileName = this.getFileNameWithExtensionFromFilePath(sourceFilePath);
                destFilePath = this.normalizePath(destFilePath, fileName);
            }
            File sourceFile = new File(sourceFilePath);
            File destFile = new File(destFilePath);
            FileUtils.copyFile((File)sourceFile, (File)destFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyFileFromURL(String sourceFilePath, String destFilePath) {
        try {
            new URL(sourceFilePath);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            FileUtils.copyURLToFile((URL)new URL(sourceFilePath), (File)new File(destFilePath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cutFile(String sourceFilePath, String destFilePath) {
        this.copyFile(sourceFilePath, destFilePath);
        this.deleteFile(sourceFilePath);
    }

    public String getFileNameWithoutExtensionFromFilePath(String filePath) {
        if (filePath.endsWith(CommonParams.PATH_SEPARATOR_CHAR)) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        return FilenameUtils.getBaseName((String)filePath);
    }

    public String getFileNameWithExtensionFromFilePath(String filePath) {
        if (filePath.endsWith(CommonParams.PATH_SEPARATOR_CHAR)) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        return FilenameUtils.getName((String)filePath);
    }

    public String getFileExtensionFromFilePath(String filePath) {
        return FilenameUtils.getExtension((String)filePath);
    }

    public String getDirectoryPathFromFilePath(String filePath) {
        if ((filePath = this.removeBackslashToEndOfDirectoryPath(filePath)).startsWith(CommonParams.PATH_SEPARATOR_CHAR)) {
            filePath = filePath.substring(1, filePath.length());
        }
        return filePath.substring(0, filePath.lastIndexOf(CommonParams.PATH_SEPARATOR_CHAR) + 1);
    }

    public String getParentDirectoryPathFromFilePath(String filePath) {
        Path directoryPath = Paths.get(filePath, new String[0]).getParent();
        if (directoryPath != null) {
            return directoryPath.toString();
        }
        return null;
    }

    public String findFileAndGetFilePath(String fileNameWildcardToFind, String directoryPathOnFind) {
        File directory = new File(directoryPathOnFind);
        WildcardFileFilter fileFilter = new WildcardFileFilter(fileNameWildcardToFind);
        File[] files = directory.listFiles((FileFilter)fileFilter);
        if (files.length != 0) {
            return files[0].getAbsolutePath();
        }
        return null;
    }

    public int contarArchivosEnCarpeta(String rutaCarpeta) {
        return this.contarArchivosEnCarpeta(rutaCarpeta, false);
    }

    public int contarArchivosEnCarpeta(String rutaCarpeta, boolean esRecursivo) {
        File f = new File(rutaCarpeta);
        int cuenta = 0;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                ++cuenta;
                File file = files[i];
                if (!file.isDirectory() || !esRecursivo) continue;
                this.contarArchivosEnCarpeta(file.getAbsolutePath(), esRecursivo);
            }
        }
        return cuenta;
    }

    public void openFile(String filePath) {
        if (this.existsFile(filePath)) {
            try {
                Desktop.getDesktop().open(new File(filePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

