/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;

public class TransactionManager<T extends AbstractDb> {
    private DataProvider dataProvider;
    private Function<Connection, T> dbSupplier;

    public TransactionManager(DataProvider dataProvider, Function<Connection, T> dbSupplier) {
        this.dataProvider = dataProvider;
        this.dbSupplier = dbSupplier;
    }

    public void transaction(Callback<T> callback) {
        this.submit(false, db -> {
            callback.call(db);
            return null;
        });
    }

    public <R> R transactionF(CallbackF<T, R> callback) {
        return this.submit(false, callback);
    }

    public void readOnly(Callback<T> callback) {
        this.submit(true, db -> {
            callback.call(db);
            return null;
        });
    }

    public <R> R readOnlyF(CallbackF<T, R> callback) {
        return this.submit(true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R submit(boolean readOnly, CallbackF<T, R> callback) {
        Connection conn = this.fetchConnection(this.dataProvider);
        try {
            if (readOnly != conn.isReadOnly()) {
                conn.setReadOnly(readOnly);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to disable auto commit ", e);
        }
        try {
            R r = this.run(conn, readOnly, callback);
            return r;
        }
        finally {
            this.close(conn);
        }
    }

    private <R> R run(Connection conn, boolean readOnly, CallbackF<T, R> callback) {
        R result;
        try {
            result = callback.call((AbstractDb)this.dbSupplier.apply(conn));
        }
        catch (Exception e) {
            this.rollback(conn);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        if (!readOnly) {
            this.commit(conn);
        } else {
            this.rollback(conn);
        }
        return result;
    }

    private void commit(Connection conn) {
        try {
            conn.commit();
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to commit connection", (Throwable)e);
        }
    }

    private void rollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to rollback connection", (Throwable)e);
        }
    }

    private Connection fetchConnection(DataProvider dataProvider) {
        Connection conn;
        try {
            conn = dataProvider.getConnection();
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to getConnection connection from " + dataProvider, (Throwable)e);
        }
        if (conn == null) {
            throw new IllegalStateException("DataProvider returned null from getConnection(): " + dataProvider);
        }
        try {
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to disable auto commit ", e);
        }
        return conn;
    }

    protected void close(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to closeQuietly connection", (Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface CallbackF<T extends AbstractDb, R> {
        public R call(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Callback<T extends AbstractDb> {
        public void call(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface DataProvider {
        public Connection getConnection() throws SQLException;
    }
}

