/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.db;

import com.github.quintans.ezSQL.Base;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.ColumnHolder;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.toolkit.utils.Strings;

public class Column<T>
extends Base<T> {
    protected Table table = null;
    protected String name = null;
    protected String alias = null;
    protected NullSql type;
    private boolean key = false;
    private boolean mandatory = false;
    private boolean version = false;
    private boolean deletion = false;
    private int _hashCode = 0;

    protected Column() {
    }

    public Column(String column, NullSql type) {
        this.name = column;
        this.alias = Strings.toCamelCase(column);
        this.type = type;
    }

    public NullSql getType() {
        return this.type;
    }

    public <C> Column<C> AS(String alias) {
        this.alias = alias;
        return this;
    }

    public ColumnHolder of(String tableAlias) {
        return new ColumnHolder(this).of(tableAlias);
    }

    public <C> Column<C> key() {
        this.key = true;
        this.table.addKey(this);
        return this;
    }

    public Column<T> mandatory() {
        this.mandatory = true;
        return this;
    }

    public <C> Column<C> version() {
        this.version = true;
        this.table.setVersionColumn(this);
        return this;
    }

    public <C> Column<C> deletion() {
        this.deletion = true;
        this.table.setDeletionColumn(this);
        return this;
    }

    public Column<T> WITH(T ... values) {
        this.getTable().WITH(this, values);
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isDeletion() {
        return this.deletion;
    }

    public Condition is() {
        return this.is(this.param());
    }

    public Function param() {
        return Definition.param(this);
    }

    public String toString() {
        return this.table + "." + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Column) {
            Column col = (Column)o;
            return col.table.equals(this.table) && this.name.equals(col.name);
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = (this.table + "." + this.name).hashCode();
        }
        return this._hashCode;
    }
}

