/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.db;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.jdbc.SimpleJdbc;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class Sequence {
    private static Logger LOGGER = Logger.getLogger(Sequence.class);
    private AbstractDb db;
    protected SimpleJdbc simpleJdbc;
    private String name;

    public Sequence(AbstractDb db, String name) {
        this.db = db;
        this.simpleJdbc = new SimpleJdbc(db.getJdbcSession());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Long fetchSequenceNextValue() {
        return this.fetchSequence(true);
    }

    public Long fetchSequenceCurrentValue() {
        return this.fetchSequence(false);
    }

    public Long fetchSequence(boolean nextValue) {
        String sql = this.db.getDriver().getSql(this, nextValue);
        long now = 0L;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SQL: " + sql));
            now = System.nanoTime();
        }
        Long id = this.simpleJdbc.queryForLong(sql, new LinkedHashMap());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("executed in: " + (double)(System.nanoTime() - now) / 1000000.0 + "ms"));
        }
        return id;
    }
}

