/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.common.api.PostDeleter;
import com.github.quintans.ezSQL.common.api.PreDeleter;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Discriminator;
import com.github.quintans.ezSQL.db.PreDeleteTrigger;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.Dml;
import com.github.quintans.ezSQL.exceptions.OptimisticLockException;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.RawSql;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class Delete
extends Dml<Delete> {
    private static final Logger LOG = Logger.getLogger(Delete.class);
    private static final String FQCN = Delete.class.getName();

    public Delete(AbstractDb db, Table table) {
        super(db, table);
    }

    @Override
    public Delete values(Object ... values) {
        throw new UnsupportedOperationException("Method 'Delete.values' is not implemented");
    }

    public Delete set(Object bean) {
        this.mapBean(bean, false);
        return this;
    }

    public int execute() {
        PreDeleteTrigger pre = this.getTable().getPreDeleteTrigger();
        if (pre != null) {
            pre.trigger(this);
        }
        return this.execute(LOG, FQCN, this.parameters);
    }

    public int[] batch() {
        PreDeleteTrigger pre = this.getTable().getPreDeleteTrigger();
        if (pre != null) {
            pre.trigger(this);
        }
        return this.batch(LOG, FQCN, this.parameters);
    }

    public int[] flushBatch() {
        return this.flushBatch(LOG, FQCN);
    }

    public void endBatch() {
        this.endBatch(LOG, FQCN);
    }

    @Override
    public RawSql getSql() {
        if (this.rawSql == null) {
            String sql = this.driver().getSql(this);
            this.rawSql = this.getSimpleJdbc().toRawSql(sql);
        }
        return this.rawSql;
    }

    public void submit(Object bean) {
        if (!this._execute(bean)) {
            throw new OptimisticLockException("No update was possible for this version of the data. Data may have changed.");
        }
        if (bean instanceof PostDeleter) {
            ((PostDeleter)bean).postDelete();
        }
    }

    public boolean execute(Object bean) {
        boolean result = this._execute(bean);
        if (bean instanceof PostDeleter) {
            ((PostDeleter)bean).postDelete();
        }
        return result;
    }

    private boolean _execute(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Cannot delete a null object.");
        }
        if (bean instanceof PreDeleter) {
            ((PreDeleter)bean).preDelete();
        }
        this.mapBean(bean, true);
        if (this.table.getDiscriminators() != null) {
            ArrayList<Condition> conditions = new ArrayList<Condition>(this.table.getDiscriminators().size());
            for (Discriminator disc : this.table.getDiscriminators()) {
                conditions.add(disc.getCondition());
            }
            this.where(conditions);
        }
        return this.execute() != 0;
    }

    private void mapBean(Object bean, boolean versioned) {
        this.parameters = new LinkedHashMap();
        this.values = new LinkedHashMap();
        ArrayList<Condition> conditions = null;
        if (bean.getClass() != this.lastBeanClass) {
            conditions = new ArrayList<Condition>();
            this.condition = null;
            this.lastBeanClass = bean.getClass();
            this.rawSql = null;
        }
        for (Column<?> column : this.table.getColumns()) {
            if (!column.isKey() && (!versioned || !column.isVersion())) continue;
            String alias = column.getAlias();
            PropertyDescriptor pd = Misc.getPropertyDescriptor(bean.getClass(), alias);
            if (pd == null) continue;
            Object o = null;
            try {
                o = pd.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to read from " + bean.getClass().getSimpleName() + "." + pd.getReadMethod().getName(), (Throwable)e);
            }
            if (column.isKey()) {
                if (o == null) {
                    throw new PersistenceException(String.format("Value for key property '%s' cannot be null.", alias));
                }
                if (conditions != null) {
                    conditions.add(column.is(Definition.param(alias)));
                }
                this.setParameter(column, o);
                continue;
            }
            if (!versioned || !column.isVersion() || o == null) continue;
            String as = "_" + alias + "_";
            if (conditions != null) {
                conditions.add(column.is(Definition.param(as)));
            }
            this.setParameter(as, o);
        }
        if (conditions != null) {
            this.where(conditions);
        }
    }
}

