/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.Base;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.dml.ColumnHolder;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.FunctionEnd;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.toolkit.utils.HashCodeUtil;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.exceptions.PersistenceException;

public class Function
extends Base<Object> {
    protected String operator;
    protected Function[] members;
    protected String alias;
    protected String tableAlias;
    protected String pseudoTableAlias;
    protected Object value;
    private int _forHash = 0;

    protected Function() {
    }

    protected Function(String operator, Object ... members) {
        this.operator = operator;
        this.members = Function.converteAll(members);
    }

    public String getOperator() {
        return this.operator;
    }

    protected void setOperator(String operator) {
        this.operator = operator;
    }

    protected void setMembers(Function ... members) {
        this.members = members;
    }

    public Function[] getMembers() {
        return this.members;
    }

    public Object getValue() {
        return this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
    }

    public String getAlias() {
        return this.alias;
    }

    public void as(String alias) {
        this.alias = alias;
    }

    protected void setTableAlias(String tableAlias) {
        if (this.members != null) {
            for (Function o : this.members) {
                if (!(o instanceof Function)) continue;
                Function func = o;
                func.setTableAlias(tableAlias);
            }
        }
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getPseudoTableAlias() {
        return this.pseudoTableAlias != null ? this.pseudoTableAlias : this.tableAlias;
    }

    protected void setPseudoTableAlias(String pseudoTableAlias) {
        this.pseudoTableAlias = pseudoTableAlias;
    }

    public Object clone() {
        return this.clone(new Function());
    }

    protected Function clone(Function function) {
        function.setOperator(this.operator);
        function.as(this.alias);
        if (this.members != null) {
            Function[] otherMembers = new Function[this.members.length];
            for (int i = 0; i < this.members.length; ++i) {
                otherMembers[i] = (Function)this.members[i].clone();
            }
            function.setMembers(otherMembers);
        } else {
            function.value = this.value instanceof Function ? ((Function)this.value).clone() : this.value;
        }
        return function;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{operator=").append(this.operator).append(", ");
        sb.append("members=");
        if (this.members != null) {
            boolean comma = false;
            sb.append("[");
            for (Function o : this.members) {
                if (comma) {
                    sb.append("; ");
                }
                sb.append(o);
                comma = true;
            }
        } else {
            sb.append("null");
        }
        sb.append(", value=").append(this.value);
        sb.append(", alias=").append(this.alias).append("]}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Function) {
            Function other = (Function)o;
            if (this.operator.equals(other.operator) && Misc.match(this.alias, other.alias) && Misc.match(this.value, other.value) && this.matchMembers(other.members)) {
                return true;
            }
        }
        return false;
    }

    private boolean matchMembers(Function ... m) {
        if (this.members == m) {
            return true;
        }
        if (this.members == null || m == null || this.members.length != m.length) {
            return false;
        }
        int idx = 0;
        for (Function o : this.members) {
            if (!Misc.match(o, m[idx])) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public int hashCode() {
        if (this._forHash == 0) {
            int result = 23;
            result = HashCodeUtil.hash((int)result, this.getClass());
            result = HashCodeUtil.hash((int)result, (Object)this.operator);
            result = HashCodeUtil.hash((int)result, (Object)this.alias);
            this._forHash = result = HashCodeUtil.hash((int)result, (Object)this.members);
        }
        return this._forHash;
    }

    public static Function converteOne(Object value) {
        if (value == null) {
            throw new PersistenceException("Value cannot be NULL. Use one of NullSql types.");
        }
        if (value instanceof Column) {
            return new ColumnHolder((Column)value);
        }
        if (value instanceof Function) {
            return (Function)((Function)value).clone();
        }
        if (value instanceof Query) {
            return Definition.subQuery((Query)value);
        }
        return new FunctionEnd("RAW", value);
    }

    public static Function[] converteAll(Object[] values) {
        Function[] tokens = new Function[values.length];
        for (int k = 0; k < values.length; ++k) {
            tokens[k] = Function.converteOne(values[k]);
        }
        return tokens;
    }
}

