/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.common.api.PostUpdater;
import com.github.quintans.ezSQL.common.api.PreUpdater;
import com.github.quintans.ezSQL.common.api.Updatable;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Discriminator;
import com.github.quintans.ezSQL.db.PreUpdateTrigger;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.Dml;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.exceptions.OptimisticLockException;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.RawSql;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class Update
extends Dml<Update> {
    private static final Logger LOG = Logger.getLogger(Update.class);
    private static final String FQCN = Update.class.getName();

    public Update(AbstractDb db, Table table) {
        super(db, table);
        this.values = new LinkedHashMap();
    }

    public Update set(Column<?> column) {
        this._set(column, column.param());
        return this;
    }

    public Update set(Column<?> col, Function value) {
        return (Update)this._set(col, value);
    }

    public <C> Update set(Column<C> col, C value) {
        return (Update)this._set(col, value);
    }

    public <C> Update set(Column<C> col, Column<C> value) {
        return (Update)this._set(col, value);
    }

    public <C> Update with(Column<C> c, C value) {
        this.setParameter(c, value);
        return this;
    }

    public Update with(String name, Object value) {
        this.setParameter(name, value);
        return this;
    }

    public Update set(Object bean) {
        this.mapBean(bean, false);
        if (bean instanceof Updatable) {
            ((Updatable)bean).clear();
        }
        return this;
    }

    public int execute() {
        PreUpdateTrigger pre = this.getTable().getPreUpdateTrigger();
        if (pre != null) {
            pre.trigger(this);
        }
        return this.execute(LOG, FQCN, this.parameters);
    }

    public int[] batch() {
        PreUpdateTrigger pre = this.getTable().getPreUpdateTrigger();
        if (pre != null) {
            pre.trigger(this);
        }
        return this.batch(LOG, FQCN, this.parameters);
    }

    public int[] flushBatch() {
        return this.flushBatch(LOG, FQCN);
    }

    public void endBatch() {
        this.endBatch(LOG, FQCN);
    }

    @Override
    public RawSql getSql() {
        if (this.rawSql == null) {
            String sql = this.driver().getSql(this);
            this.rawSql = this.getSimpleJdbc().toRawSql(sql);
        }
        return this.rawSql;
    }

    public void submit(Object bean) {
        if (!this._execute(bean)) {
            throw new OptimisticLockException("No update was possible for this version of the data. Data may have changed.");
        }
        if (bean instanceof PostUpdater) {
            ((PostUpdater)bean).postUpdate();
        }
        if (bean instanceof Updatable) {
            ((Updatable)bean).clear();
        }
    }

    public boolean execute(Object bean) {
        boolean result = this._execute(bean);
        if (bean instanceof PostUpdater) {
            ((PostUpdater)bean).postUpdate();
        }
        if (bean instanceof Updatable) {
            ((Updatable)bean).clear();
        }
        return result;
    }

    private boolean _execute(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Cannot update a null object.");
        }
        if (bean instanceof PreUpdater) {
            ((PreUpdater)bean).preUpdate();
        }
        IdVer idVer = this.mapBean(bean, true);
        if (idVer.noId) {
            throw new PersistenceException("Field ID is undefined!");
        }
        if (this.table.getDiscriminators() != null) {
            ArrayList<Condition> conditions = new ArrayList<Condition>(this.table.getDiscriminators().size());
            for (Discriminator disc : this.table.getDiscriminators()) {
                conditions.add(disc.getCondition());
                this.values.remove(disc.getColumn());
            }
            this.where(conditions);
        }
        int result = this.execute();
        if (idVer.versionBeanProperty != null && result > 0) {
            try {
                idVer.versionBeanProperty.getWriteMethod().invoke(bean, idVer.versionValue);
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to set Version data.", (Throwable)e);
            }
        }
        return result != 0;
    }

    private IdVer mapBean(Object bean, boolean versioned) {
        this.parameters = new LinkedHashMap();
        this.values = new LinkedHashMap();
        ArrayList<Condition> conditions = null;
        if (bean.getClass() != this.lastBeanClass) {
            conditions = new ArrayList<Condition>();
            this.condition = null;
            this.lastBeanClass = bean.getClass();
            this.rawSql = null;
        }
        IdVer idVer = new IdVer();
        Set changed = null;
        if (bean instanceof Updatable) {
            changed = ((Updatable)bean).changed();
        }
        for (Column<?> column : this.table.getColumns()) {
            Object o;
            PropertyDescriptor pd;
            String alias = column.getAlias();
            if (changed != null && !column.isKey() && !column.isVersion() && !changed.contains(alias) || (pd = Misc.getPropertyDescriptor(bean.getClass(), alias)) == null) continue;
            try {
                o = pd.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to read from " + bean.getClass().getSimpleName() + "." + pd.getReadMethod().getName(), (Throwable)e);
            }
            if (column.isKey()) {
                if (o == null) {
                    throw new PersistenceException(String.format("Value for key property '%s' cannot be null.", alias));
                }
                if (conditions != null) {
                    conditions.add(column.is(Definition.param(alias)));
                }
                this.setParameter(alias, o);
                idVer.noId = false;
                continue;
            }
            if (versioned && column.isVersion()) {
                if (o == null) continue;
                idVer.versionValue = Long.class.isAssignableFrom(pd.getPropertyType()) ? (Number)((Long)o + 1L) : (Number)((Integer)o + 1);
                String as = "_" + alias + "_";
                if (conditions != null) {
                    conditions.add(column.is(Definition.param(as)));
                }
                this.setParameter(as, o);
                this._set(column, idVer.versionValue);
                idVer.versionBeanProperty = pd;
                continue;
            }
            this._set(column, o);
        }
        if (conditions != null) {
            this.where(conditions);
        }
        return idVer;
    }

    private static class IdVer {
        boolean noId = true;
        PropertyDescriptor versionBeanProperty = null;
        Object versionValue = null;

        private IdVer() {
        }
    }
}

