/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.dml.AutoKeyStrategy;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.GenericDriver;
import com.github.quintans.jdbc.exceptions.PersistenceException;

public class DB2Driver
extends GenericDriver {
    @Override
    public String getAutoNumberQuery(Column<? extends Number> column) {
        return this.getAutoNumberQuery(column, false);
    }

    @Override
    public String getCurrentAutoNumberQuery(Column<? extends Number> column) {
        return this.getAutoNumberQuery(column, true);
    }

    @Override
    public String getAutoNumberQuery(Column<? extends Number> column, boolean current) {
        if (column.isKey()) {
            return "select IDENTITY_VAL_LOCAL() from sysibm.sysdummy1";
        }
        throw new PersistenceException(String.format("A fun\u00e7\u00e3o getAutoNumberQuery n\u00e3o reconhece a coluna %s.", column));
    }

    @Override
    public AutoKeyStrategy getAutoKeyStrategy() {
        return AutoKeyStrategy.AFTER;
    }

    @Override
    protected String getDefault() {
        return "default";
    }

    public int getMaxTableChars() {
        return 30;
    }

    @Override
    public boolean useSQLPagination() {
        return false;
    }

    @Override
    public String secondsdiff(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("TIMESTAMPDIFF (2, char(%s)) + 1", this.rolloverParameter(dmlType, new Object[]{o[1], o[0]}, " - "));
    }

    @Override
    public String paginate(Query query, String sql) {
        if (query.getSkip() > 0) {
            query.setParameter("first", (Object)(query.getSkip() + 1));
            query.setParameter("last", (Object)(query.getSkip() + query.getLimit()));
            return String.format("SELECT * FROM (SELECT rr.*, ROW_NUMBER() OVER() AS rn FROM (%s FETCH FIRST :%s ROWS ONLY) AS rr) AS r WHERE rn >= :%s ORDER BY rn", sql, "last", "first");
        }
        if (query.getLimit() > 0) {
            query.setParameter("last", (Object)query.getLimit());
            return String.format("%s fetch first :%s rows only", sql, "last");
        }
        return sql;
    }
}

