/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.common.type.MyDate;
import com.github.quintans.ezSQL.common.type.MyDateTime;
import com.github.quintans.ezSQL.common.type.MyTime;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Sequence;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.AutoKeyStrategy;
import com.github.quintans.ezSQL.dml.Delete;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Insert;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.dml.Update;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.sp.SqlProcedure;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public interface Driver {
    public String translate(EDml var1, Function var2);

    public String getSql(SqlProcedure var1);

    public String getSql(Insert var1);

    public String getSql(Query var1);

    public String getSql(Update var1);

    public String getSql(Delete var1);

    public String getSql(Sequence var1, boolean var2);

    public AutoKeyStrategy getAutoKeyStrategy();

    public String getAutoNumberQuery(Column<? extends Number> var1);

    public String getCurrentAutoNumberQuery(Column<? extends Number> var1);

    public boolean useSQLPagination();

    public boolean ignoreNullKeys();

    public int paginationColumnOffset(Query var1);

    public void prepareConnection(Connection var1);

    public String tableName(Table var1);

    public String tableAlias(String var1);

    public String columnName(Column<?> var1);

    public String columnAlias(Function var1, int var2);

    public Object toIdentity(ResultSetWrapper var1, int var2) throws SQLException;

    public Boolean toBoolean(ResultSetWrapper var1, int var2) throws SQLException;

    public String toString(ResultSetWrapper var1, int var2) throws SQLException;

    public Byte toTiny(ResultSetWrapper var1, int var2) throws SQLException;

    public Short toShort(ResultSetWrapper var1, int var2) throws SQLException;

    public Integer toInteger(ResultSetWrapper var1, int var2) throws SQLException;

    public Long toLong(ResultSetWrapper var1, int var2) throws SQLException;

    public Double toDecimal(ResultSetWrapper var1, int var2) throws SQLException;

    public MyTime toTime(ResultSetWrapper var1, int var2) throws SQLException;

    public MyDate toDate(ResultSetWrapper var1, int var2) throws SQLException;

    public MyDateTime toDateTime(ResultSetWrapper var1, int var2) throws SQLException;

    public Date toTimestamp(ResultSetWrapper var1, int var2) throws SQLException;

    public InputStream toText(ResultSetWrapper var1, int var2) throws SQLException;

    public InputStream toBin(ResultSetWrapper var1, int var2) throws SQLException;

    public BigDecimal toBigDecimal(ResultSetWrapper var1, int var2) throws SQLException;

    public Object fromIdentity(Object var1);

    public Object fromBoolean(Boolean var1);

    public Object fromString(String var1);

    public Object fromTiny(Byte var1);

    public Object fromShort(Short var1);

    public Object fromInteger(Integer var1);

    public Object fromLong(Long var1);

    public Object fromDecimal(Double var1);

    public Object fromTime(Date var1);

    public Object fromDate(Date var1);

    public Object fromDateTime(Date var1);

    public Object fromTimestamp(Date var1);

    public Object fromText(InputStream var1, int var2);

    public Object fromBin(InputStream var1, int var2);

    public Object fromBigDecimal(BigDecimal var1);

    public Object fromUnknown(Object var1);

    public Object fromNull(NullSql var1);

    public <T> T fromDb(ResultSetWrapper var1, int var2, Class<T> var3) throws SQLException;
}

