/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Delete;
import com.github.quintans.ezSQL.driver.DeleteBuilder;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.toolkit.utils.Appender;

public class GenericDeleteBuilder
implements DeleteBuilder {
    protected Delete delete;
    protected Appender tablePart = new Appender(", ");
    protected Appender wherePart = new Appender(" AND ");

    public GenericDeleteBuilder(Delete delete) {
        this.delete = delete;
        this.from();
        this.where();
    }

    protected Driver driver() {
        return this.delete.getDb().getDriver();
    }

    public void from() {
        Table table = this.delete.getTable();
        String alias = this.delete.getTableAlias();
        this.tablePart.addAsOne(this.driver().tableName(table), " ", this.driver().tableAlias(alias));
    }

    @Override
    public String getTablePart() {
        return this.tablePart.toString();
    }

    public void where() {
        Condition criteria = this.delete.getCondition();
        if (criteria != null) {
            this.wherePart.add(this.driver().translate(EDml.DELETE, criteria));
        }
    }

    @Override
    public String getWherePart() {
        return this.wherePart.toString();
    }
}

