/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.common.api.Value;
import com.github.quintans.ezSQL.common.type.MyDate;
import com.github.quintans.ezSQL.common.type.MyDateTime;
import com.github.quintans.ezSQL.common.type.MyTime;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Sequence;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.ColumnHolder;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Delete;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Insert;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.dml.Update;
import com.github.quintans.ezSQL.driver.DeleteBuilder;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.GenericDeleteBuilder;
import com.github.quintans.ezSQL.driver.GenericInsertBuilder;
import com.github.quintans.ezSQL.driver.GenericQueryBuilder;
import com.github.quintans.ezSQL.driver.GenericUpdateBuilder;
import com.github.quintans.ezSQL.driver.InsertBuilder;
import com.github.quintans.ezSQL.driver.QueryBuilder;
import com.github.quintans.ezSQL.driver.UpdateBuilder;
import com.github.quintans.ezSQL.jdbc.AbstractPreparedStatementCallback;
import com.github.quintans.ezSQL.sp.SqlProcedure;
import com.github.quintans.ezSQL.toolkit.io.AutoCloseInputStream;
import com.github.quintans.ezSQL.toolkit.io.BinStore;
import com.github.quintans.ezSQL.toolkit.io.TextStore;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;

public abstract class GenericDriver
implements Driver {
    private Calendar calendar = Calendar.getInstance();

    public void setTimeZoneId(String tzId) {
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone(tzId));
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public String getAutoNumberQuery(Column<? extends Number> column) {
        return this.getAutoNumberQuery(column, false);
    }

    @Override
    public String getCurrentAutoNumberQuery(Column<? extends Number> column) {
        return this.getAutoNumberQuery(column, true);
    }

    public String getAutoNumberQuery(Column<? extends Number> column, boolean current) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toIdentity(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Object o = rs.getObject(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public Boolean toBoolean(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Boolean o = rs.getBoolean(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public String toString(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        String o = rs.getString(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public Byte toTiny(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Byte o = rs.getByte(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public Short toShort(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Short o = rs.getShort(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public Integer toInteger(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Integer o = rs.getInt(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public Long toLong(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Long o = rs.getLong(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public Double toDecimal(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Double o = rs.getDouble(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public BigDecimal toBigDecimal(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        BigDecimal o = rs.getBigDecimal(columnIndex);
        return rs.wasNull() ? null : o;
    }

    @Override
    public MyTime toTime(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Time o = rs.getTime(columnIndex);
        return rs.wasNull() ? null : new MyTime(o.getTime());
    }

    @Override
    public MyDate toDate(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Date o = rs.getDate(columnIndex);
        return rs.wasNull() ? null : new MyDate(o.getTime());
    }

    @Override
    public MyDateTime toDateTime(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Timestamp o = rs.getTimestamp(columnIndex);
        return rs.wasNull() ? null : new MyDateTime(((java.util.Date)o).getTime());
    }

    @Override
    public java.util.Date toTimestamp(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Timestamp o = rs.getTimestamp(columnIndex, this.getCalendar());
        return rs.wasNull() ? null : o;
    }

    @Override
    public InputStream toText(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        InputStream in = rs.getAsciiStream(columnIndex);
        if (in == null || rs.wasNull()) {
            return null;
        }
        return in;
    }

    @Override
    public InputStream toBin(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        InputStream in = rs.getBinaryStream(columnIndex);
        if (in == null || rs.wasNull()) {
            return null;
        }
        return in;
    }

    @Override
    public Object fromNull(NullSql type) {
        return type;
    }

    @Override
    public Object fromIdentity(Object o) {
        return o == null ? this.fromNull(NullSql.BIGINT) : o;
    }

    @Override
    public Object fromBoolean(Boolean o) {
        return o == null ? this.fromNull(NullSql.BOOLEAN) : o;
    }

    @Override
    public Object fromString(String o) {
        return o == null ? this.fromNull(NullSql.VARCHAR) : o;
    }

    @Override
    public Object fromTiny(Byte o) {
        return o == null ? this.fromNull(NullSql.TINY) : o;
    }

    @Override
    public Object fromShort(Short o) {
        return o == null ? this.fromNull(NullSql.SMALL) : o;
    }

    @Override
    public Object fromInteger(Integer o) {
        return o == null ? this.fromNull(NullSql.INTEGER) : o;
    }

    @Override
    public Object fromLong(Long o) {
        return o == null ? this.fromNull(NullSql.BIGINT) : o;
    }

    @Override
    public Object fromDecimal(Double o) {
        return o == null ? this.fromNull(NullSql.DECIMAL) : o;
    }

    @Override
    public Object fromBigDecimal(BigDecimal o) {
        return o == null ? this.fromNull(NullSql.DECIMAL) : o;
    }

    @Override
    public Object fromTime(final java.util.Date o) {
        if (o == null) {
            return this.fromNull(NullSql.TIME);
        }
        return new AbstractPreparedStatementCallback(o){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setTime(columnIndex, new Time(o.getTime()));
            }
        };
    }

    @Override
    public Object fromDate(final java.util.Date o) {
        if (o == null) {
            return this.fromNull(NullSql.DATE);
        }
        return new AbstractPreparedStatementCallback(o){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setDate(columnIndex, new Date(o.getTime()));
            }
        };
    }

    @Override
    public Object fromDateTime(final java.util.Date o) {
        if (o == null) {
            return this.fromNull(NullSql.TIMESTAMP);
        }
        return new AbstractPreparedStatementCallback(o){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setTimestamp(columnIndex, new Timestamp(o.getTime()));
            }
        };
    }

    @Override
    public Object fromTimestamp(final java.util.Date o) {
        if (o == null) {
            return this.fromNull(NullSql.TIMESTAMP);
        }
        return new AbstractPreparedStatementCallback(o){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setTimestamp(columnIndex, new Timestamp(o.getTime()), GenericDriver.this.getCalendar());
            }
        };
    }

    @Override
    public Object fromText(final InputStream is, final int length) {
        if (is == null) {
            return this.fromNull(NullSql.CLOB);
        }
        return new AbstractPreparedStatementCallback(is){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setAsciiStream(columnIndex, (InputStream)new AutoCloseInputStream(is), length);
            }
        };
    }

    @Override
    public Object fromBin(final InputStream is, final int length) {
        if (is == null) {
            return this.fromNull(NullSql.BLOB);
        }
        return new AbstractPreparedStatementCallback(is){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setBinaryStream(columnIndex, (InputStream)new AutoCloseInputStream(is), length);
            }
        };
    }

    @Override
    public Object fromUnknown(Object o) {
        if (o instanceof java.util.Date) {
            return this.fromDate((java.util.Date)o);
        }
        if (o instanceof Boolean) {
            return this.fromBoolean((Boolean)o);
        }
        return o;
    }

    @Override
    public boolean ignoreNullKeys() {
        return false;
    }

    @Override
    public String getSql(SqlProcedure procedure) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (procedure.isFunction()) {
            sb.append(" ? =");
        }
        sb.append(" call ").append(procedure.getName()).append("(");
        int start = procedure.isFunction() ? 1 : 0;
        int len = procedure.getParameters().size();
        for (int i = 0; i < len; ++i) {
            if (i > start) {
                sb.append(", ");
            }
            sb.append("?");
        }
        sb.append(") }");
        return sb.toString();
    }

    public InsertBuilder createInsertBuilder(Insert insert) {
        return new GenericInsertBuilder(insert);
    }

    @Override
    public String getSql(Insert insert) {
        InsertBuilder proc = this.createInsertBuilder(insert);
        StringBuilder str = new StringBuilder();
        str.append("INSERT INTO ").append(proc.getTablePart()).append("(").append(proc.getColumnPart()).append(") VALUES(").append(proc.getValuePart()).append(")");
        return str.toString();
    }

    protected String getDefault() {
        return "NULL";
    }

    public UpdateBuilder createUpdateBuilder(Update update) {
        return new GenericUpdateBuilder(update);
    }

    @Override
    public String getSql(Update update) {
        UpdateBuilder proc = this.createUpdateBuilder(update);
        StringBuilder sel = new StringBuilder();
        sel.append("UPDATE ").append(proc.getTablePart());
        sel.append(" SET ").append(proc.getColumnPart());
        if (!proc.getWherePart().isEmpty()) {
            sel.append(" WHERE ").append(proc.getWherePart());
        }
        return sel.toString();
    }

    protected DeleteBuilder createDeleteBuilder(Delete delete) {
        return new GenericDeleteBuilder(delete);
    }

    @Override
    public String getSql(Delete delete) {
        DeleteBuilder processor = this.createDeleteBuilder(delete);
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(processor.getTablePart());
        String where = processor.getWherePart();
        if (!where.isEmpty()) {
            sb.append(" WHERE ").append(where);
        }
        return sb.toString();
    }

    @Override
    public String getSql(Sequence sequence, boolean nextValue) {
        throw new UnsupportedOperationException();
    }

    public QueryBuilder createQueryBuilder(Query query) {
        return new GenericQueryBuilder(query);
    }

    @Override
    public String getSql(Query query) {
        int[] groupBy;
        QueryBuilder proc = this.createQueryBuilder(query);
        StringBuilder sel = new StringBuilder();
        sel.append("SELECT ");
        if (query.isDistinct()) {
            sel.append("DISTINCT ");
        }
        sel.append(proc.getColumnPart());
        sel.append(" FROM ").append(proc.getFromPart());
        sel.append(proc.getJoinPart());
        if (!proc.getWherePart().isEmpty()) {
            sel.append(" WHERE ").append(proc.getWherePart());
        }
        if ((groupBy = query.getGroupBy()) != null && groupBy.length != 0) {
            sel.append(" GROUP BY ").append(proc.getGroupPart());
        }
        if (query.getHaving() != null) {
            sel.append(" HAVING ").append(proc.getHavingPart());
        }
        if (Misc.length(query.getUnions()) != 0) {
            sel.append(proc.getUnionPart());
        }
        if (Misc.length(query.getOrders()) != 0) {
            sel.append(" ORDER BY ").append(proc.getOrderPart());
        }
        return this.paginate(query, sel.toString());
    }

    @Override
    public String translate(EDml dmlType, Function function) {
        String op = function.getOperator();
        if ("COLUMN".equals(op)) {
            return this.columnName(dmlType, function);
        }
        if ("EQ".equals(op)) {
            return this.match(dmlType, function);
        }
        if ("NEQ".equals(op)) {
            return this.diferent(dmlType, function);
        }
        if ("IN".equals(op)) {
            return this.in(dmlType, function);
        }
        if ("RANGE".equals(op)) {
            return this.range(dmlType, function);
        }
        if ("VALUERANGE".equals(op)) {
            return this.valueRange(dmlType, function);
        }
        if ("BOUNDEDRANGE".equals(op)) {
            return this.boundedValueRange(dmlType, function);
        }
        if ("ISNULL".equals(op)) {
            return this.isNull(dmlType, function);
        }
        if ("LIKE".equals(op)) {
            return this.like(dmlType, function);
        }
        if ("ILIKE".equals(op)) {
            return this.ilike(dmlType, function);
        }
        if ("IEQ".equals(op)) {
            return this.iMatch(dmlType, function);
        }
        if ("AND".equals(op)) {
            return this.and(dmlType, function);
        }
        if ("OR".equals(op)) {
            return this.or(dmlType, function);
        }
        if ("GT".equals(op)) {
            return this.greater(dmlType, function);
        }
        if ("LT".equals(op)) {
            return this.lesser(dmlType, function);
        }
        if ("GTEQ".equals(op)) {
            return this.greaterOrMatch(dmlType, function);
        }
        if ("LTEQ".equals(op)) {
            return this.lesserOrMatch(dmlType, function);
        }
        if ("EXISTS".equals(op)) {
            return this.exists(dmlType, function);
        }
        if ("PARAM".equals(op)) {
            return this.param(dmlType, function);
        }
        if ("RAW".equals(op) || "VAL".equals(op)) {
            return this.val(dmlType, function);
        }
        if ("ALIAS".equals(op)) {
            return this.alias(dmlType, function);
        }
        if ("COUNT".equals(op)) {
            return this.count(dmlType, function);
        }
        if ("ADD".equals(op)) {
            return this.add(dmlType, function);
        }
        if ("MINUS".equals(op)) {
            return this.minus(dmlType, function);
        }
        if ("SECONDSDIFF".equals(op)) {
            return this.secondsdiff(dmlType, function);
        }
        if ("SUM".equals(op)) {
            return this.sum(dmlType, function);
        }
        if ("MAX".equals(op)) {
            return this.max(dmlType, function);
        }
        if ("MIN".equals(op)) {
            return this.min(dmlType, function);
        }
        if ("MULTIPLY".equals(op)) {
            return this.multiply(dmlType, function);
        }
        if ("RTRIM".equals(op)) {
            return this.rtrim(dmlType, function);
        }
        if ("NOW".equals(op)) {
            return this.now(dmlType, function);
        }
        if ("SUBQUERY".equals(op)) {
            return this.subQuery(dmlType, function);
        }
        if ("AUTONUM".equals(op)) {
            return this.autoNumber(dmlType, function);
        }
        if ("UPPER".equals(op)) {
            return this.upper(dmlType, function);
        }
        if ("LOWER".equals(op)) {
            return this.lower(dmlType, function);
        }
        if ("COALESCE".equals(op)) {
            return this.coalesce(dmlType, function);
        }
        if ("CASE".equals(op)) {
            return this.caseStatement(dmlType, function);
        }
        if ("CASE_WHEN".equals(op)) {
            return this.caseWhen(dmlType, function);
        }
        if ("CASE_ELSE".equals(op)) {
            return this.caseElse(dmlType, function);
        }
        throw new PersistenceException("Function " + op + " unknown");
    }

    protected String rolloverParameter(EDml dmlType, Object[] o, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int f = 0; f < o.length; ++f) {
            if (f > 0 && separator != null) {
                sb.append(separator);
            }
            sb.append(this.translate(dmlType, (Function)o[f]));
        }
        return sb.toString();
    }

    private String isNot(Condition c) {
        return c.isNot() ? "NOT " : "";
    }

    @Override
    public boolean useSQLPagination() {
        return true;
    }

    @Override
    public String tableName(Table table) {
        return table.getName();
    }

    @Override
    public String tableAlias(String alias) {
        return alias;
    }

    @Override
    public String columnName(Column<?> column) {
        return column.getName();
    }

    @Override
    public String columnAlias(Function function, int position) {
        return function.getAlias();
    }

    public String columnName(EDml dmlType, Function function) {
        if (function instanceof ColumnHolder) {
            ColumnHolder ch = (ColumnHolder)function;
            return (ch.getTableAlias() == null ? this.tableName(ch.getColumn().getTable()) : ch.getTableAlias()) + "." + this.columnName(ch.getColumn());
        }
        return "";
    }

    public String match(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("%s = %s", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    public String iMatch(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("UPPER(%s) = UPPER(%s)", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    public String diferent(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("%s <> %s", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    public String range(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        String field = this.translate(dmlType, o[0]);
        String bottom = this.translate(dmlType, o[1]);
        String top = this.translate(dmlType, o[2]);
        if (bottom != null && top != null) {
            return String.format("%s >= %s AND %s <= %s", field, bottom, field, top);
        }
        throw new PersistenceException("Fun\u00e7\u00e3o Range Invalida");
    }

    public String valueRange(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        String bottom = this.translate(dmlType, o[0]);
        String top = this.translate(dmlType, o[1]);
        String value = null;
        if (o[2] != null) {
            value = this.translate(dmlType, o[2]);
        }
        if (value != null) {
            return String.format("(%1$s IS NULL AND %2$s IS NULL OR %1$s IS NULL AND %2$s <= %3$s OR %2$s IS NULL AND %1$s >= %3$s OR %1$s >= %3$s AND %2$s <= %3$s)", top, bottom, value);
        }
        throw new PersistenceException("Fun\u00e7\u00e3o ValueRange Invalida");
    }

    public String boundedValueRange(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        String bottom = this.translate(dmlType, o[0]);
        String top = this.translate(dmlType, o[1]);
        String value = null;
        if (o[2] != null) {
            value = this.translate(dmlType, o[2]);
        }
        if (value != null) {
            return String.format("(%1$s >= %3$s AND %2$s <= %3$s)", top, bottom, value);
        }
        throw new PersistenceException("Fun\u00e7\u00e3o BoundedRange Invalida");
    }

    public String in(EDml dmlType, Function function) {
        Condition c = (Condition)function;
        Object[] o = function.getMembers();
        String pattern = null;
        pattern = o[1].getOperator().equals("SUBQUERY") ? "%s%s IN %s" : "%s%s IN (%s)";
        return String.format(pattern, this.isNot(c), this.translate(dmlType, o[0]), this.rolloverParameter(dmlType, this.slice(o, 1), ", "));
    }

    public String or(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("(%s)", this.rolloverParameter(dmlType, o, " OR "));
    }

    public String and(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("%s", this.rolloverParameter(dmlType, o, " AND "));
    }

    public String like(EDml dmlType, Function function) {
        Condition c = (Condition)function;
        Function[] o = function.getMembers();
        return String.format("%s %sLIKE %s", this.translate(dmlType, o[0]), this.isNot(c), this.translate(dmlType, o[1]));
    }

    public String ilike(EDml dmlType, Function function) {
        Condition c = (Condition)function;
        Function[] o = function.getMembers();
        return String.format("UPPER(%s) %sLIKE UPPER(%s)", this.translate(dmlType, o[0]), this.isNot(c), this.translate(dmlType, o[1]));
    }

    public String isNull(EDml dmlType, Function function) {
        Condition c = (Condition)function;
        Function[] o = function.getMembers();
        return String.format("%s IS %sNULL", this.translate(dmlType, o[0]), this.isNot(c));
    }

    public String greater(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("%s > %s", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    public String lesser(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("%s < %s", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    public String greaterOrMatch(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("%s >= %s", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    public String lesserOrMatch(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("%s <= %s", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    private Object[] slice(Object[] o, int begin) {
        Object[] pars = new Object[o.length - begin];
        System.arraycopy(o, begin, pars, 0, pars.length);
        return pars;
    }

    public String param(EDml dmlType, Function function) {
        return ":" + function.getValue();
    }

    public String val(EDml dmlType, Function function) {
        Object o = function.getValue();
        return o != null ? (o instanceof String ? "'" + o + "'" : o.toString()) : "NULL";
    }

    public String exists(EDml dmlType, Function function) {
        Condition c = (Condition)function;
        Function[] o = function.getMembers();
        return String.format("%sEXISTS %s", this.isNot(c), this.translate(dmlType, o[0]));
    }

    public String alias(EDml dmlType, Function function) {
        Object o = function.getValue();
        return o != null ? o.toString() : "NULL";
    }

    public String sum(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("SUM(%s)", this.rolloverParameter(dmlType, o, ", "));
    }

    public String max(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("MAX(%s)", this.rolloverParameter(dmlType, o, ", "));
    }

    public String min(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("MIN(%s)", this.rolloverParameter(dmlType, o, ", "));
    }

    public String add(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return this.rolloverParameter(dmlType, o, " + ");
    }

    public String minus(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return this.rolloverParameter(dmlType, o, " - ");
    }

    public String secondsdiff(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return this.rolloverParameter(dmlType, new Object[]{o[1], o[0]}, " - ");
    }

    public String multiply(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return this.rolloverParameter(dmlType, o, " * ");
    }

    public String count(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("COUNT(%s)", o.length == 0 ? "*" : this.translate(dmlType, o[0]));
    }

    public String rtrim(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("RTRIM(%s)", this.translate(dmlType, o[0]));
    }

    public String subQuery(EDml dmlType, Function function) {
        return String.format("( %s )", this.getSql((Query)function.getValue()));
    }

    public String now(EDml dmlType, Function function) {
        throw new UnsupportedOperationException("O metodo 'now' n\u00e3o \u00e9 suportado.");
    }

    public String upper(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("UPPER(%s)", this.translate(dmlType, o[0]));
    }

    public String lower(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("LOWER(%s)", this.translate(dmlType, o[0]));
    }

    public String coalesce(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("COALESCE(%s)", this.rolloverParameter(dmlType, o, ", "));
    }

    public String caseStatement(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("CASE %s END", this.rolloverParameter(dmlType, o, " "));
    }

    public String caseWhen(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("WHEN %s THEN %s", this.translate(dmlType, o[0]), this.translate(dmlType, o[1]));
    }

    public String caseElse(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        return String.format("ELSE %s", this.translate(dmlType, o[0]));
    }

    public String autoNumber(EDml dmlType, Function function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int paginationColumnOffset(Query query) {
        return 0;
    }

    @Override
    public void prepareConnection(Connection connection) {
    }

    public abstract String paginate(Query var1, String var2);

    protected Object toDefault(ResultSetWrapper rsw, int position) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Object o = rs.getObject(position);
        return rs.wasNull() ? null : o;
    }

    @Override
    public <T> T fromDb(ResultSetWrapper rsw, int position, Class<T> klass) throws SQLException {
        if (klass == null) {
            return (T)this.toDefault(rsw, position);
        }
        Object val = null;
        if (klass.isAssignableFrom(Boolean.class) || klass.isAssignableFrom(Boolean.TYPE)) {
            val = this.toBoolean(rsw, position);
        } else if (klass.isAssignableFrom(BigDecimal.class)) {
            val = this.toBigDecimal(rsw, position);
        } else if (klass.isAssignableFrom(Byte.class) || klass.isAssignableFrom(Byte.TYPE)) {
            val = this.toTiny(rsw, position);
        } else if (klass.isAssignableFrom(Short.class) || klass.isAssignableFrom(Short.TYPE)) {
            val = this.toShort(rsw, position);
        } else if (klass.isAssignableFrom(Integer.class) || klass.isAssignableFrom(Integer.TYPE)) {
            val = this.toInteger(rsw, position);
        } else if (klass.isAssignableFrom(Long.class) || klass.isAssignableFrom(Long.TYPE)) {
            val = this.toLong(rsw, position);
        } else if (klass.isAssignableFrom(Double.class) || klass.isAssignableFrom(Double.TYPE)) {
            val = this.toDecimal(rsw, position);
        } else if (klass.isAssignableFrom(java.util.Date.class)) {
            val = this.toTimestamp(rsw, position);
        } else if (klass.isAssignableFrom(MyTime.class)) {
            val = this.toTime(rsw, position);
        } else if (klass.isAssignableFrom(MyDate.class)) {
            val = this.toDate(rsw, position);
        } else if (klass.isAssignableFrom(MyDateTime.class)) {
            val = this.toDateTime(rsw, position);
        } else if (TextStore.class.isAssignableFrom(klass)) {
            val = new TextStore();
            Misc.copy(this.toText(rsw, position), (BinStore)val);
        } else if (BinStore.class.isAssignableFrom(klass)) {
            val = new BinStore();
            Misc.copy(this.toBin(rsw, position), (BinStore)val);
        } else if (klass.isEnum()) {
            int sqlType = rsw.getSqlType(position);
            if (12 == sqlType) {
                String value = this.toString(rsw, position);
                if (value != null) {
                    if (Value.class.isAssignableFrom(klass)) {
                        for (T element : klass.getEnumConstants()) {
                            Value e = (Value)element;
                            if (!e.value().equals(value)) continue;
                            val = element;
                            break;
                        }
                    } else {
                        for (T element : klass.getEnumConstants()) {
                            Enum e = (Enum)element;
                            if (!e.name().equals(value)) continue;
                            val = element;
                            break;
                        }
                    }
                }
            } else {
                Integer value = this.toInteger(rsw, position);
                if (value != null) {
                    int v = value;
                    if (Value.class.isAssignableFrom(klass)) {
                        for (T element : klass.getEnumConstants()) {
                            Value e = (Value)element;
                            if (((Number)e.value()).intValue() != v) continue;
                            val = element;
                            break;
                        }
                    } else {
                        for (T element : klass.getEnumConstants()) {
                            Enum e = (Enum)element;
                            if (e.ordinal() != v) continue;
                            val = element;
                            break;
                        }
                    }
                }
            }
        } else if (klass.isAssignableFrom(byte[].class)) {
            InputStream in = this.toBin(rsw, position);
            if (in != null) {
                try {
                    val = IOUtils.toByteArray((InputStream)in);
                }
                catch (IOException e) {
                    throw new PersistenceException("Unable to convert stream into bytes!", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        } else if (klass.isAssignableFrom(String.class)) {
            int sqlType = rsw.getSqlType(position);
            if (2005 == sqlType || -16 == sqlType) {
                InputStream in = this.toText(rsw, position);
                if (in != null) {
                    try {
                        val = IOUtils.toString((InputStream)in, (String)"UTF-8");
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Unable to convert stream into bytes!", (Throwable)e);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
            } else {
                val = this.toString(rsw, position);
            }
        }
        return (T)val;
    }
}

