/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Association;
import com.github.quintans.ezSQL.db.Relation;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Group;
import com.github.quintans.ezSQL.dml.Join;
import com.github.quintans.ezSQL.dml.Order;
import com.github.quintans.ezSQL.dml.PathElement;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.dml.Union;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.QueryBuilder;
import com.github.quintans.ezSQL.toolkit.utils.Appender;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import java.util.ArrayList;
import java.util.List;

public class GenericQueryBuilder
implements QueryBuilder {
    protected Query query;
    protected Appender columnPart = new Appender(", ");
    protected Appender fromPart = new Appender(", ");
    protected StringBuilder joinPart = new StringBuilder();
    protected Appender wherePart = new Appender(" AND ");
    protected Appender groupPart = new Appender(", ");
    protected StringBuilder havingPart = new StringBuilder();
    protected Appender orderPart = new Appender(", ");
    protected StringBuilder unionPart = new StringBuilder();

    public GenericQueryBuilder(Query query) {
        this.query = query;
        this.column();
        if (query.getTable() != null) {
            this.from();
        } else {
            this.fromSubQuery();
        }
        this.where();
        this.appendJoins();
        this.group();
        this.having();
        this.union();
        this.order();
    }

    protected Driver driver() {
        return this.query.getDb().getDriver();
    }

    @Override
    public String getColumnPart() {
        return this.columnPart.toString();
    }

    @Override
    public String getFromPart() {
        return this.fromPart.toString();
    }

    @Override
    public String getJoinPart() {
        return this.joinPart.toString();
    }

    @Override
    public String getWherePart() {
        return this.wherePart.toString();
    }

    @Override
    public String getGroupPart() {
        return this.groupPart.toString();
    }

    @Override
    public String getHavingPart() {
        return this.havingPart.toString();
    }

    @Override
    public String getOrderPart() {
        return this.orderPart.toString();
    }

    @Override
    public String getUnionPart() {
        return this.unionPart.toString();
    }

    public void column() {
        int k = 0;
        for (Function token : this.query.getColumns()) {
            this.columnPart.add(this.driver().translate(EDml.QUERY, token));
            String a = this.driver().columnAlias(token, k + 1);
            if (a != null) {
                this.columnPart.append(" AS ", a);
            }
            ++k;
        }
    }

    public void from() {
        Table table = this.query.getTable();
        String alias = this.query.getTableAlias();
        this.fromPart.addAsOne(this.driver().tableName(table), " ", this.driver().tableAlias(alias));
    }

    public void fromSubQuery() {
        Query subquery = this.query.getSubquery();
        String alias = this.query.getAlias();
        this.fromPart.addAsOne("(", this.driver().getSql(subquery), ")");
        if (alias != null) {
            this.fromPart.append(" ", alias);
        }
    }

    public void joinAssociation(Association fk, boolean inner) {
        if (inner) {
            this.joinPart.append(" INNER JOIN ");
        } else {
            this.joinPart.append(" LEFT OUTER JOIN ");
        }
        this.joinPart.append(this.driver().tableName(fk.getTableTo()) + " " + fk.getAliasTo() + " ON ");
        Relation[] relations = fk.getRelations();
        for (int i = 0; i < relations.length; ++i) {
            if (i > 0) {
                this.joinPart.append(" AND ");
            }
            Relation rel = relations[i];
            this.joinPart.append(this.driver().translate(EDml.QUERY, rel.getFrom()) + " = " + this.driver().translate(EDml.QUERY, rel.getTo()));
        }
    }

    public void joinCriteria(Condition criteria) {
        this.joinPart.append(" AND ").append(this.driver().translate(EDml.QUERY, criteria));
    }

    public void where() {
        Condition criteria = this.query.getCondition();
        if (criteria != null) {
            this.wherePart.add(this.driver().translate(EDml.QUERY, criteria));
        }
    }

    public void group() {
        List<Group> groups = this.query.getGroupByFunction();
        if (Misc.length(groups) > 0) {
            for (Group group : groups) {
                this.groupPart.add(this.driver().translate(EDml.QUERY, group.getFunction()));
            }
        }
    }

    public void having() {
        Condition having = this.query.getHaving();
        if (having != null) {
            this.havingPart.append(this.driver().translate(EDml.QUERY, having));
        }
    }

    public void order() {
        List<Order> orders = this.query.getOrders();
        if (Misc.length(orders) > 0) {
            for (Order ord : orders) {
                if (ord.getHolder() != null) {
                    this.orderPart.add(this.driver().translate(EDml.QUERY, ord.getHolder()));
                } else {
                    this.orderPart.add(ord.getAlias());
                }
                if (ord.isAsc()) {
                    this.orderPart.append(" ASC");
                    continue;
                }
                this.orderPart.append(" DESC");
            }
        }
    }

    public void union() {
        List<Union> unions = this.query.getUnions();
        if (Misc.length(unions) > 0) {
            for (Union u : unions) {
                this.unionPart.append(" UNION ");
                if (u.isAll()) {
                    this.unionPart.append("ALL ");
                }
                this.unionPart.append(this.driver().getSql(u.getQuery()));
            }
        }
    }

    protected PathElement[] deepestCommonPath(List<PathElement[]> cachedAssociation, List<PathElement> associations) {
        ArrayList common = new ArrayList();
        if (Misc.length(associations) > 0) {
            for (PathElement[] path : cachedAssociation) {
                ArrayList<PathElement> temp = new ArrayList<PathElement>();
                for (int depth = 0; depth < path.length; ++depth) {
                    PathElement pe2;
                    PathElement pe = path[depth];
                    if (depth >= associations.size() || (pe2 = associations.get(depth)).isInner() != null && !pe2.isInner().equals(pe.isInner()) || pe2.getBase() == null || !pe2.getBase().equals(pe.getBase())) break;
                    temp.add(pe2);
                }
                if (temp.size() <= common.size()) continue;
                common = temp;
            }
        }
        return common.toArray(new PathElement[0]);
    }

    protected List<PathElement> reduceAssociations(List<PathElement[]> cachedAssociation, Join join) {
        List<PathElement> associations = join.getPathElements();
        PathElement[] common = this.deepestCommonPath(cachedAssociation, associations);
        List<PathElement> pes = join.getPathElements();
        cachedAssociation.add(pes.toArray(new PathElement[pes.size()]));
        return associations.subList(common.length, associations.size());
    }

    protected void appendJoins() {
        List<Join> joins = this.query.getJoins();
        if (Misc.length(joins) == 0) {
            return;
        }
        ArrayList<PathElement[]> cachedAssociation = new ArrayList<PathElement[]>();
        for (Join join : joins) {
            List<PathElement> associations = this.reduceAssociations(cachedAssociation, join);
            if (Misc.length(associations) <= 0) continue;
            for (PathElement pe : associations) {
                Association association = pe.getDerived();
                if (association.isMany2Many()) {
                    Association fromFk = association.getFromM2M();
                    Association toFk = association.getToM2M();
                    this.joinAssociation(fromFk, pe.isInner());
                    this.joinAssociation(toFk, pe.isInner());
                } else {
                    this.joinAssociation(association, pe.isInner());
                }
                if (pe.getCondition() == null) continue;
                this.joinCriteria(pe.getCondition());
            }
        }
    }
}

