/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.AutoKeyStrategy;
import com.github.quintans.ezSQL.dml.Delete;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.driver.DeleteBuilder;
import com.github.quintans.ezSQL.driver.GenericDeleteBuilder;
import com.github.quintans.ezSQL.driver.GenericDriver;
import com.github.quintans.jdbc.PreparedStatementCallback;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class MySQLDriver
extends GenericDriver {
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final String TIME_FORMAT = "HH:mm:ss";
    private final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
    private String TIME_ZONE = "UTC";

    public MySQLDriver() {
        this.setTimeZoneId(this.TIME_ZONE);
    }

    @Override
    public String getAutoNumberQuery(Column<? extends Number> column, boolean current) {
        if (column.isKey()) {
            return "SELECT LAST_INSERT_ID()";
        }
        throw new PersistenceException(String.format("column '%s' must be key.", column));
    }

    @Override
    public boolean useSQLPagination() {
        return true;
    }

    @Override
    public String paginate(Query query, String sql) {
        StringBuilder sb = new StringBuilder();
        if (query.getLimit() > 0) {
            sb.append(sql).append(" LIMIT :").append("last");
            query.setParameter("last", (Object)query.getLimit());
            if (query.getSkip() > 0) {
                sb.append(", :").append("first");
                query.setParameter("first", (Object)query.getSkip());
            }
            return sb.toString();
        }
        return sql;
    }

    @Override
    public AutoKeyStrategy getAutoKeyStrategy() {
        return AutoKeyStrategy.RETURNING;
    }

    @Override
    public Date toTimestamp(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Timestamp o = rs.getTimestamp(columnIndex, this.getCalendar());
        return rs.wasNull() ? null : o;
    }

    @Override
    public String tableName(Table table) {
        return "`" + table.getName().toUpperCase() + "`";
    }

    @Override
    public String columnName(Column<?> column) {
        return "`" + column.getName().toUpperCase() + "`";
    }

    @Override
    public Object fromDateTime(final Date o) {
        if (o == null) {
            return NullSql.DATE;
        }
        return new PreparedStatementCallback(){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setTimestamp(columnIndex, new Timestamp(o.getTime()));
            }
        };
    }

    @Override
    protected DeleteBuilder createDeleteBuilder(Delete delete) {
        return new GenericDeleteBuilder(delete){

            @Override
            public void from() {
                Table table = this.delete.getTable();
                String alias = this.delete.getTableAlias();
                this.tablePart.addAsOne(alias, " USING ", this.driver().tableName(table), " AS ", alias);
            }
        };
    }
}

