/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.sp;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.dml.Dml;
import com.github.quintans.jdbc.SimpleJdbc;
import com.github.quintans.jdbc.sp.SqlParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SqlProcedure {
    private static Logger LOG = Logger.getLogger(SqlProcedure.class);
    private static final String FQCN = Dml.class.getCanonicalName();
    private AbstractDb db;
    protected SimpleJdbc simpleJdbc;
    private SqlParameter returnType;
    private String name = "";
    private List<SqlParameter> parameters;

    public SqlProcedure(AbstractDb db, String name, SqlParameter ... params) {
        this(db, null, name, params);
    }

    public SqlProcedure(AbstractDb db, SqlParameter returnType, String name, SqlParameter ... params) {
        this.db = db;
        this.simpleJdbc = new SimpleJdbc(db.getJdbcSession());
        this.returnType = returnType;
        this.name = name;
        this.parameters = new ArrayList<SqlParameter>();
        if (this.parameters != null) {
            for (SqlParameter parameter : params) {
                this.parameters.add(parameter);
            }
        }
    }

    public SqlParameter getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public List<SqlParameter> getParameters() {
        return this.parameters;
    }

    public boolean isFunction() {
        return this.returnType != null;
    }

    public Map<String, Object> call() {
        return this.call(new HashMap<String, Object>());
    }

    public Map<String, Object> call(Map<String, Object> values) {
        ArrayList<SqlParameter> copies = new ArrayList<SqlParameter>();
        if (this.isFunction()) {
            copies.add(new SqlParameter(this.getReturnType()));
        }
        for (SqlParameter parameter : this.getParameters()) {
            SqlParameter copy = new SqlParameter(parameter);
            copies.add(copy);
            if (!parameter.isIn() || !values.containsKey(parameter.getName())) continue;
            copy.setValue(values.get(parameter.getName()));
        }
        String sql = this.db.getDriver().getSql(this);
        this.debugSQL(sql, copies);
        long now = System.nanoTime();
        Map response = this.simpleJdbc.call(sql, copies);
        this.debugTime(now);
        return response;
    }

    private String dumpParameters(List<SqlParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        for (SqlParameter parameter : parameters) {
            if (parameter.isIn()) {
                if (parameter.getValue() != null) {
                    sb.append(String.format("[%s:%s=%s]", parameter.getType(), parameter.getName(), parameter.getValue().toString()));
                    continue;
                }
                sb.append(String.format("[%s:%s=NULL]", parameter.getType(), parameter.getName()));
                continue;
            }
            sb.append(String.format("[%s:%s]", parameter.getType(), parameter.getName()));
        }
        return sb.toString();
    }

    private void debugTime(long now) {
        if (LOG.isDebugEnabled()) {
            LOG.log(FQCN, (Priority)Level.DEBUG, (Object)("executed in: " + (double)(System.nanoTime() - now) / 1000000.0 + "ms"), null);
        }
    }

    private void debugSQL(String sql, List<SqlParameter> copies) {
        if (LOG.isDebugEnabled()) {
            LOG.log(FQCN, (Priority)Level.DEBUG, (Object)String.format("\n\tSQL: %s\n\tparameters: %s", sql, this.dumpParameters(copies)), null);
        }
    }
}

