/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.toolkit.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AutoCloseInputStream
extends FilterInputStream {
    private boolean streamOpen = true;
    private boolean selfClosed = false;

    public AutoCloseInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int l = -1;
        if (this.isReadAllowed()) {
            l = super.read();
            this.checkClose(l);
        }
        return l;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        if (this.isReadAllowed()) {
            l = super.read(b, off, len);
            this.checkClose(l);
        }
        return l;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int l = -1;
        if (this.isReadAllowed()) {
            l = super.read(b);
            this.checkClose(l);
        }
        return l;
    }

    @Override
    public void close() throws IOException {
        if (!this.selfClosed) {
            this.selfClosed = true;
            this.streamEnded();
        }
    }

    private void checkClose(int readResult) throws IOException {
        if (readResult == -1) {
            this.streamEnded();
        }
    }

    private boolean isReadAllowed() throws IOException {
        if (!this.streamOpen && this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.streamOpen;
    }

    private void streamEnded() throws IOException {
        if (this.streamOpen) {
            super.close();
            this.streamOpen = false;
        }
    }
}

