/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.transformers;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.common.api.Updatable;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.toolkit.io.BinStore;
import com.github.quintans.ezSQL.toolkit.io.TextStore;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.transformers.IRowTransformer;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;

public abstract class AbstractDbRowTransformer<T>
implements IRowTransformer<T> {
    private AbstractDb db;

    public AbstractDbRowTransformer(AbstractDb db) {
        this.db = db;
    }

    public Collection<T> beforeAll(ResultSetWrapper rsw) {
        return null;
    }

    public abstract T transform(ResultSetWrapper var1) throws SQLException;

    public void onTransformation(Collection<T> result, T object) {
        if (object instanceof Updatable) {
            ((Updatable)object).clear();
        }
    }

    public void afterAll(Collection<T> result) {
    }

    protected Driver driver() {
        return this.db.getDriver();
    }

    public Object toIdentity(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toIdentity(rs, columnIndex);
    }

    public Boolean toBoolean(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toBoolean(rs, columnIndex);
    }

    public String toString(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toString(rs, columnIndex);
    }

    public Byte toTiny(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toTiny(rs, columnIndex);
    }

    public Short toShort(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toShort(rs, columnIndex);
    }

    public Integer toInteger(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toInteger(rs, columnIndex);
    }

    public Long toLong(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toLong(rs, columnIndex);
    }

    public Double toDecimal(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toDecimal(rs, columnIndex);
    }

    public BigDecimal toBigDecimal(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toBigDecimal(rs, columnIndex);
    }

    public Date toTime(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toTime(rs, columnIndex);
    }

    public Date toDate(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toDate(rs, columnIndex);
    }

    public Date toDateTime(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toDateTime(rs, columnIndex);
    }

    public Date toTimestamp(ResultSetWrapper rs, int columnIndex) throws SQLException {
        return this.driver().toTimestamp(rs, columnIndex);
    }

    public TextStore toText(ResultSetWrapper rs, int columnIndex) throws SQLException {
        TextStore val = new TextStore();
        Misc.copy(this.driver().toText(rs, columnIndex), val);
        return val;
    }

    public BinStore toBin(ResultSetWrapper rs, int columnIndex) throws SQLException {
        BinStore val = new BinStore();
        Misc.copy(this.driver().toBin(rs, columnIndex), val);
        return val;
    }
}

