/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.transformers;

import com.github.quintans.ezSQL.db.Association;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.ColumnHolder;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Join;
import com.github.quintans.ezSQL.dml.PathElement;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.transformers.IQueryRowTransformer;
import com.github.quintans.ezSQL.transformers.MapColumn;
import com.github.quintans.ezSQL.transformers.MapTable;
import com.github.quintans.ezSQL.transformers.QueryMapper;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MapTransformer<T>
implements IQueryRowTransformer<T> {
    private MapTable rootNode;
    private Map<List<Object>, Object> domainCache;
    private Query query;
    private Driver driver;
    private int offset;
    private boolean reuse;
    private QueryMapper mapper;

    public MapTransformer(Query query, boolean reuse, QueryMapper mapper) {
        this.query = query;
        this.reuse = reuse;
        this.mapper = mapper;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(Query query) {
        this.query = query;
    }

    public Collection<T> beforeAll(ResultSetWrapper rsw) {
        this.driver = this.query.getDb().getDriver();
        this.offset = this.query.getDb().getDriver().paginationColumnOffset(this.query);
        if (!this.query.isFlat() && this.reuse) {
            this.domainCache = new HashMap<List<Object>, Object>();
        }
        this.rootNode = this.buildTree();
        return this.domainCache != null ? new LinkedHashSet() : new ArrayList();
    }

    protected MapTable buildTree() {
        HashMap<String, MapTable> tableNodes = new HashMap<String, MapTable>();
        Table table = this.query.getTable();
        MapTable rootNode = this.buildTreeAndCheckKeys(table, this.query.getTableAlias(), "");
        tableNodes.put(rootNode.getTableAlias(), rootNode);
        if (this.query.getJoins() != null) {
            for (Join join : this.query.getJoins()) {
                if (!join.isFetch()) continue;
                for (PathElement pe : join.getPathElements()) {
                    for (Association fk : join.getAssociations()) {
                        String aliasTo;
                        String string = aliasTo = fk.isMany2Many() ? fk.getToM2M().getAliasTo() : fk.getAliasTo();
                        if (tableNodes.containsKey(aliasTo)) continue;
                        Table tableTo = fk.isMany2Many() ? fk.getToM2M().getTableTo() : fk.getTableTo();
                        MapTable mapTable = this.buildTreeAndCheckKeys(tableTo, aliasTo, fk.getAlias());
                        tableNodes.put(aliasTo, mapTable);
                        String aliasFrom = fk.isMany2Many() ? fk.getFromM2M().getAliasFrom() : fk.getAliasFrom();
                        MapTable parent = (MapTable)tableNodes.get(aliasFrom);
                        parent.addTableNode(mapTable);
                    }
                }
            }
        }
        return rootNode;
    }

    private MapTable buildTreeAndCheckKeys(Table table, String tableAlias, String associationAlias) {
        MapTable mapTable = new MapTable(tableAlias, table.getName(), associationAlias);
        int tableKeys = 0;
        int queryKeys = 0;
        int index = 0;
        for (Function column : this.query.getColumns()) {
            String pseudoAlias;
            ColumnHolder ch;
            ++index;
            boolean isKey = false;
            if (this.reuse && column instanceof ColumnHolder && (ch = (ColumnHolder)column).getColumn().isKey() && ch.getTableAlias().equals(tableAlias)) {
                isKey = true;
                ++queryKeys;
                for (Column<?> col : table.getColumns()) {
                    if (!col.equals(ch.getColumn())) continue;
                    ++tableKeys;
                    break;
                }
            }
            if (!tableAlias.equals(pseudoAlias = this.query.isFlat() ? this.query.getTableAlias() : column.getPseudoTableAlias())) continue;
            mapTable.addColumnNode(new MapColumn(this.offset + index, column.getAlias(), isKey));
        }
        if (this.reuse && tableKeys != queryKeys) {
            throw new PersistenceException("At least one Key column was not found for " + table.toString() + ". When transforming to a object tree and reusing previous beans, ALL key columns must be declared in the select.");
        }
        return mapTable;
    }

    public T transform(ResultSetWrapper rsw) throws SQLException {
        if (this.domainCache == null) {
            this.rootNode.reset();
        }
        this.rootNode.process(rsw, this.domainCache, this.offset, null, this.mapper);
        return (T)this.rootNode.getInstance();
    }

    public void onTransformation(Collection<T> result, T object) {
        if (object != null) {
            result.add(object);
        }
    }

    public void afterAll(Collection<T> result) {
        if (this.rootNode != null) {
            this.rootNode.reset();
        }
    }

    protected <T> T fromDb(ResultSetWrapper rsw, int columnIndex, Class<T> type) throws SQLException {
        return this.driver.fromDb(rsw, columnIndex, type);
    }
}

