/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.rx;

import io.reactivesprint.Preconditions;
import io.reactivesprint.rx.CommandNotEnabledException;
import io.reactivesprint.rx.ConstantProperty;
import io.reactivesprint.rx.ICommand;
import io.reactivesprint.rx.IProperty;
import io.reactivesprint.rx.MutableProperty;
import io.reactivesprint.rx.Property;
import io.reactivesprint.rx.functions.Func1BooleanNot;
import io.reactivesprint.rx.functions.FuncNBooleanAnd;
import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observables.ConnectableObservable;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public final class Command<I, R>
implements ICommand<I, R> {
    private final Func1<I, Observable<R>> createObservable;
    private final Subject<Notification<R>, Notification<R>> notifications = PublishSubject.create();
    private final Observable<R> values;
    private final Observable<Throwable> errors;
    private final MutableProperty<Boolean> executing = new MutableProperty<Boolean>(false);
    private final IProperty<Boolean> enabled;
    private final Object lock = new Object();

    public Command(Func1<I, Observable<R>> createObservable) {
        this(new ConstantProperty<Boolean>(true), createObservable);
    }

    public Command(IProperty<Boolean> enabled, Func1<I, Observable<R>> createObservable) {
        Preconditions.checkNotNull(createObservable, "createObservable");
        this.createObservable = createObservable;
        Subject<Notification<R>, Notification<R>> notificationObservable = this.notifications;
        this.values = notificationObservable.filter(new Func1<Notification<R>, Boolean>(){

            public Boolean call(Notification<R> outputNotification) {
                return outputNotification.isOnNext();
            }
        }).dematerialize();
        this.errors = notificationObservable.filter(new Func1<Notification<R>, Boolean>(){

            public Boolean call(Notification<R> outputNotification) {
                return outputNotification.isOnError();
            }
        }).map(new Func1<Notification<R>, Throwable>(){

            public Throwable call(Notification<R> outputNotification) {
                return outputNotification.getThrowable();
            }
        });
        this.enabled = new Property<Boolean>(false, Observable.combineLatest(enabled.getObservable(), (Observable)this.isExecuting().getObservable().map((Func1)Func1BooleanNot.getInstance()), (Func2)FuncNBooleanAnd.getInstance()));
    }

    @Override
    public Observable<R> apply() {
        return this.apply(null);
    }

    @Override
    public Observable<R> apply(final I input) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super R> subscriber) {
                boolean startedExecuting = false;
                Object object = Command.this.lock;
                synchronized (object) {
                    if (((Boolean)Command.this.enabled.getValue()).booleanValue()) {
                        Command.this.executing.setValue(true);
                        startedExecuting = true;
                    }
                }
                if (!startedExecuting) {
                    subscriber.onError((Throwable)new CommandNotEnabledException());
                    return;
                }
                ConnectableObservable connectableObservable = ((Observable)Command.this.createObservable.call(input)).lift(new OperatorIgnoreErrorNotImplemented()).publish();
                Subscription subscription = connectableObservable.materialize().subscribe(new Action1<Notification<R>>(){

                    public void call(Notification<R> outputNotification) {
                        Command.this.notifications.onNext(outputNotification);
                    }
                });
                subscriber.add(subscription);
                subscriber.add(connectableObservable.subscribe(subscriber));
                subscriber.add(new Subscription(){

                    public void unsubscribe() {
                        Command.this.executing.setValue(false);
                    }

                    public boolean isUnsubscribed() {
                        return (Boolean)Command.this.executing.getValue() == false;
                    }
                });
                connectableObservable.connect();
            }
        });
    }

    @Override
    public Observable<Notification<R>> getNotifications() {
        return this.notifications.asObservable();
    }

    @Override
    public Observable<R> getValues() {
        return this.values;
    }

    @Override
    public IProperty<Boolean> isEnabled() {
        return this.enabled;
    }

    @Override
    public IProperty<Boolean> isExecuting() {
        return new Property<Boolean>(this.executing);
    }

    @Override
    public Observable<Throwable> getErrors() {
        return this.errors;
    }

    protected void finalize() throws Throwable {
        this.notifications.onCompleted();
        super.finalize();
    }

    private static final class OperatorIgnoreErrorNotImplemented<T>
    implements Observable.Operator<T, T> {
        private OperatorIgnoreErrorNotImplemented() {
        }

        public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
            return new Subscriber<T>(){

                public void onCompleted() {
                    subscriber.onCompleted();
                }

                public void onError(Throwable e) {
                    try {
                        subscriber.onError(e);
                    }
                    catch (OnErrorNotImplementedException onErrorNotImplementedException) {
                        // empty catch block
                    }
                }

                public void onNext(T r) {
                    subscriber.onNext(r);
                }
            };
        }
    }
}

