/*
 * Decompiled with CFR 0.152.
 */
package com.github.silencesu.behavior3java.composites;

import com.github.silencesu.behavior3java.constant.B3Status;
import com.github.silencesu.behavior3java.core.Blackboard;
import com.github.silencesu.behavior3java.core.Composite;
import com.github.silencesu.behavior3java.core.Tick;

public class MemSequence
extends Composite {
    @Override
    public void onOpen(Tick tick) {
        Blackboard.Memory memory = tick.getBlackboard().getMemeory(tick.getTree().getId(), this.getId());
        memory.getMemeory().put("runningChild", 0);
    }

    @Override
    public B3Status onTick(Tick tick) {
        Blackboard.Memory mm = tick.getBlackboard().getMemeory(tick.getTree().getId(), this.getId());
        int child = (Integer)mm.getMemeory().get("runningChild");
        int childCount = this.getChildCount();
        for (int i = child; i < childCount; ++i) {
            B3Status status = this.getChild(i).execute(tick);
            if (status == B3Status.SUCCESS) continue;
            if (status == B3Status.RUNNING) {
                tick.getBlackboard().setParam("runningChild", i, tick.getTree().getId(), this.getId());
            }
            return status;
        }
        return B3Status.SUCCESS;
    }
}

