/*
 * Decompiled with CFR 0.152.
 */
package com.github.silencesu.behavior3java.core;

import com.github.silencesu.behavior3java.config.BTNodeCfg;
import com.github.silencesu.behavior3java.config.BTTreeCfg;
import com.github.silencesu.behavior3java.config.DefaultNodes;
import com.github.silencesu.behavior3java.constant.B3Status;
import com.github.silencesu.behavior3java.core.BaseNode;
import com.github.silencesu.behavior3java.core.BehaviorTreeProject;
import com.github.silencesu.behavior3java.core.Blackboard;
import com.github.silencesu.behavior3java.core.IComposite;
import com.github.silencesu.behavior3java.core.IDecorator;
import com.github.silencesu.behavior3java.core.SubTree;
import com.github.silencesu.behavior3java.core.Tick;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BehaviorTree {
    private static final Logger log = LoggerFactory.getLogger(BehaviorTree.class);
    private String id = UUID.randomUUID().toString().replaceAll("-", "");
    private String titile;
    private String description;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private BaseNode root;
    private BehaviorTreeProject projectInfo;

    public void load(BTTreeCfg cfg) {
        this.load(cfg, new HashMap<String, Class<? extends BaseNode>>());
    }

    public void load(BTTreeCfg cfg, Map<String, Class<? extends BaseNode>> extendNodes) {
        BTNodeCfg nodeCfg;
        this.titile = cfg.getTitle();
        this.description = cfg.getDescription();
        this.properties = cfg.getProperties();
        HashMap<String, Class<? extends BaseNode>> nodeMaps = new HashMap<String, Class<? extends BaseNode>>(DefaultNodes.get());
        if (extendNodes != null && extendNodes.size() > 0) {
            nodeMaps.putAll(extendNodes);
        }
        HashMap<String, Object> nodes = new HashMap<String, Object>();
        for (Map.Entry<String, BTNodeCfg> nodeEntry : cfg.getNodes().entrySet()) {
            String id = nodeEntry.getKey();
            nodeCfg = nodeEntry.getValue();
            Object node = null;
            if (nodeCfg.getCategory().equals("tree")) {
                node = new SubTree();
            } else {
                Class clazz = (Class)nodeMaps.get(nodeCfg.getName());
                if (clazz != null) {
                    try {
                        node = (BaseNode)clazz.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (node == null) {
                log.error("create node erro:{}", (Object)nodeCfg.getName());
                break;
            }
            ((BaseNode)node).initialize(nodeCfg);
            if (this.projectInfo != null) {
                ((BaseNode)node).setProjectInfo(this.projectInfo);
            }
            nodes.put(id, node);
        }
        for (Map.Entry<String, BTNodeCfg> nodeEntry : cfg.getNodes().entrySet()) {
            BaseNode node = (BaseNode)nodes.get(nodeEntry.getKey());
            nodeCfg = nodeEntry.getValue();
            if (node.getCategory().equals("composite") && nodeCfg.getChildren() != null) {
                for (String cid : nodeCfg.getChildren()) {
                    IComposite comp = (IComposite)((Object)node);
                    comp.addChild((BaseNode)nodes.get(cid));
                }
                continue;
            }
            if (!node.getCategory().equals("decorator") || nodeCfg.getChild().length() <= 0) continue;
            IDecorator deco = (IDecorator)((Object)node);
            deco.setChild((BaseNode)nodes.get(nodeCfg.getChild()));
        }
        this.root = (BaseNode)nodes.get(cfg.getRoot());
    }

    public <T> B3Status tick(T t, Blackboard blackboard) {
        int i;
        if (blackboard == null) {
            log.error("The blackboard parameter is obligatory and must be an instance of b3.Blackboard");
            return B3Status.ERROR;
        }
        Tick tick = new Tick();
        tick.setTarget(t);
        tick.setBlackboard(blackboard);
        tick.setTree(this);
        B3Status status = this.root.run(tick);
        List<BaseNode> lastOpenNodes = blackboard.getTreeData((String)this.id).openNodes;
        List<BaseNode> currOpenNodes = tick.getOpenNodes();
        int start = 0;
        for (i = 0; i < (lastOpenNodes.size() > currOpenNodes.size() ? currOpenNodes.size() : lastOpenNodes.size()); ++i) {
            start = i + 1;
            if (lastOpenNodes.get(i) != currOpenNodes.get(i)) break;
        }
        for (i = lastOpenNodes.size() - 1; i >= start; --i) {
            lastOpenNodes.get(i).close(tick);
        }
        blackboard.getTreeData((String)this.id).openNodes = currOpenNodes;
        blackboard.SetTree("nodeCount", tick.getNodeCount(), this.id);
        return status;
    }

    public String getId() {
        return this.id;
    }

    public String getTitile() {
        return this.titile;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public BaseNode getRoot() {
        return this.root;
    }

    public BehaviorTreeProject getProjectInfo() {
        return this.projectInfo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitile(String titile) {
        this.titile = titile;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setRoot(BaseNode root) {
        this.root = root;
    }

    public void setProjectInfo(BehaviorTreeProject projectInfo) {
        this.projectInfo = projectInfo;
    }
}

