/*
 * Decompiled with CFR 0.152.
 */
package com.github.thstock.djp.util;

import com.github.thstock.djp.util.Tuple;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class XStream<T> {
    private final Stream<T> inner;

    XStream(Stream<T> stream) {
        this.inner = stream;
    }

    public XStream<T> filter(Predicate<? super T> predicate) {
        return XStream.stream(this.stream().filter(predicate));
    }

    public XStream<T> filterNot(Predicate<? super T> predicate) {
        return this.filter(p -> !predicate.test(p));
    }

    public <R> XStream<R> map(Function<? super T, ? extends R> f) {
        return XStream.stream(this.stream().map(f));
    }

    public <R> XStream<R> flatMap(Function<? super T, ? extends XStream<R>> f) {
        return XStream.stream(this.stream().flatMap((? super T in) -> ((XStream)f.apply(in)).stream()));
    }

    public T last(Predicate<? super T> predicate) {
        return this.filter(predicate).last();
    }

    public T last() {
        return (T)Iterables.getLast(this.toList());
    }

    Stream<T> stream() {
        return this.inner;
    }

    static <T> XStream<T> from(T ... elements) {
        return new XStream<T>(Stream.of(elements));
    }

    public static <T> XStream<T> from(List<T> elements) {
        return new XStream(elements.stream());
    }

    static <T> XStream<T> from(Stream<T> stream) {
        return new XStream<T>(stream);
    }

    private static <T> XStream<T> stream(Stream<T> stream) {
        return new XStream<T>(stream);
    }

    public boolean isEmpty() {
        return this.toList().isEmpty();
    }

    public ImmutableList<T> toList() {
        return ImmutableList.copyOf((Collection)this.stream().collect(Collectors.toList()));
    }

    public static <T> XStream<T> empty() {
        return new XStream(Stream.empty());
    }

    public XStream<T> drop(int limit) {
        if (limit < 0) {
            return XStream.from(this.toList());
        }
        return XStream.from(this.toList().stream().skip(limit));
    }

    public XStream<T> take(int size) {
        return XStream.from(this.toList().stream().limit(size));
    }

    public T head() {
        return (T)Iterables.getFirst(this.toList(), null);
    }

    public <K, V> ImmutableMap<K, V> toMap(Function<T, Tuple<K, V>> fn) {
        Map<Object, Object> collect = this.stream().collect(Collectors.toMap(k -> ((Tuple)fn.apply(k)).getKey(), v -> ((Tuple)fn.apply(v)).getValue()));
        return ImmutableMap.copyOf(collect);
    }

    public ImmutableMap<String, String> toMap(Splitter splitter) {
        return this.map(Object::toString).toMap((T in) -> {
            List strings = splitter.splitToList((CharSequence)in);
            if (strings.size() != 2) {
                throw new IllegalStateException("invalid split: " + strings);
            }
            return Tuple.of(strings.get(0), strings.get(1));
        });
    }

    public String mkString() {
        return this.map(Object::toString).stream().collect(Collectors.joining());
    }

    public String mkString(CharSequence seperator) {
        return this.map(Object::toString).stream().collect(Collectors.joining(seperator));
    }
}

