/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.cli;

import com.github.yin.cli.ArgumentProvider;
import com.github.yin.cli.AutoValue_Flag;
import com.github.yin.cli.FlagID;
import com.github.yin.cli.TypeConversions;

public abstract class Flag<T> {
    static <T> Flag create(FlagID flagID, Class<T> type, ArgumentProvider index, TypeConversions typeConversions) {
        return new AutoValue_Flag<T>(flagID, type, index, typeConversions);
    }

    abstract FlagID flagID();

    abstract Class<T> type();

    protected abstract ArgumentProvider flags();

    protected abstract TypeConversions typeConversions();

    public T get() {
        TypeConversions.Conversion<T> conversion = this.typeConversions().forType(this.type());
        if (conversion != null) {
            String value = this.flags().singleArgument(this.flagID());
            return conversion.apply(value);
        }
        throw new UnsupportedOperationException(String.format("Type conversion for Flag<%s>s is registered, Flag: %s", this.type().getCanonicalName(), this.flagID().toString()));
    }
}

