/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.cli;

import com.github.yin.cli.TypeConversionRegistrar;
import com.github.yin.cli.TypeConversions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class TypeConversionsImpl
implements TypeConversions,
TypeConversionRegistrar {
    private HashMap<Class<?>, TypeConversions.Conversion> typeConversions = Maps.newHashMap();
    private final ImmutableMap DEFAULT_CONVERSIONS = ImmutableMap.builder().put(String.class, (Object)new TypeConversions.Conversion<String>(){

        @Override
        public String apply(String s) {
            return s;
        }
    }).put(Integer.class, (Object)new TypeConversions.Conversion<Integer>(){

        @Override
        public Integer apply(String s) {
            return Integer.parseInt(s);
        }
    }).put(Float.class, (Object)new TypeConversions.Conversion<Float>(){

        @Override
        public Float apply(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }
    }).put(Double.class, (Object)new TypeConversions.Conversion<Double>(){

        @Override
        public Double apply(String s) {
            return Double.parseDouble(s);
        }
    }).put(BigInteger.class, (Object)new TypeConversions.Conversion<BigInteger>(){

        @Override
        public BigInteger apply(String s) {
            return new BigInteger(s);
        }
    }).put(BigDecimal.class, (Object)new TypeConversions.Conversion<BigDecimal>(){

        @Override
        public BigDecimal apply(String s) {
            return new BigDecimal(s);
        }
    }).build();

    @Override
    public <T> TypeConversions.Conversion<T> forType(Class<T> type) {
        return this.typeConversions.containsKey(type) ? this.typeConversions.get(type) : (TypeConversions.Conversion)this.DEFAULT_CONVERSIONS.get(type);
    }

    @Override
    public <T> void register(Class<T> type, TypeConversions.Conversion<T> conversion) {
        this.typeConversions.put(type, conversion);
    }

    @Override
    public <T> void unregister(Class<T> type) {
        this.typeConversions.remove(type);
    }
}

