/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.cli.parsing;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public class LongKeyValueParser {
    private final String[] args;

    public LongKeyValueParser(String[] args) {
        this.args = args;
    }

    public ImmutableMultimap<String, String> parse() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ArgumentReader reader = new ArgumentReader(this.args);
        while (reader.hasNext()) {
            String flag = reader.key();
            String value = reader.value();
            builder.put((Object)flag, (Object)value);
        }
        return builder.build();
    }

    static class ArgumentReader {
        private final Iterator<String> iterator;

        public ArgumentReader(String[] args) {
            this.iterator = Iterators.forArray((Object[])args);
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public String key() {
            String next = this.iterator.next();
            if (next.startsWith("--")) {
                return next.substring(2);
            }
            throw new IllegalArgumentException("Argument '" + next + "' is not a flag");
        }

        public String value() {
            String next = this.iterator.next();
            return next;
        }
    }
}

