/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.github.yin.flags.AutoValue_Flags_Error;
import com.github.yin.flags.ClassMetadataIndex;
import com.github.yin.flags.Flag;
import com.github.yin.flags.FlagID;
import com.github.yin.flags.FlagIndex;
import com.github.yin.flags.FlagMetadata;
import com.github.yin.flags.analysis.UsagePrinter;
import com.github.yin.flags.annotations.ClassScanner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Flags {
    private static ArgumentIndex arguments;
    private static final FlagIndex<Flag<?>> flagIndex;
    private static final FlagIndex<FlagMetadata> flagMetadataIndex;
    private static final ClassMetadataIndex classMetadataIndex;
    private static final List<Error> errors;
    private static boolean collectErrors;
    private static ClassScanner classScanner;

    public static boolean init(String[] args) {
        arguments = Flags.indexArguments(args);
        return arguments != null;
    }

    public static Flag<String> string(String name) {
        return Flags.create(String.class, name);
    }

    public static <T> Flag<T> create(Class<T> type, String name) {
        try {
            String callerClass = Flags.scanCallerClass();
            FlagID id = FlagID.create(callerClass, name);
            Flag flag = Flag.create(id, type, arguments);
            flagIndex.add(id, flag);
            return flag;
        }
        catch (ClassNotFoundException ex) {
            Throwables.propagate((Throwable)ex);
            return null;
        }
    }

    public static void printUsage(String packageProfix) {
        classScanner.scanPackage(packageProfix, flagMetadataIndex, classMetadataIndex);
        new UsagePrinter().printUsage(flagMetadataIndex, classMetadataIndex, System.out);
    }

    @VisibleForTesting
    public static void initForTesting(Map<String, String> options) {
        Flags.indexMap(options);
    }

    public static void enableErrorCollection(boolean collectErrors) {
        Flags.collectErrors = collectErrors;
    }

    public static ImmutableList<Error> getErrors() {
        return ImmutableList.copyOf(errors);
    }

    private static String scanCallerClass() throws ClassNotFoundException {
        String className = Flags.getCallerClassName();
        classScanner.scanClass(className, flagMetadataIndex, classMetadataIndex);
        return className;
    }

    private static ArgumentIndex indexArguments(String[] args) {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])args);
        ArgsAcceptor acceptor = new ArgsAcceptor();
        acceptor.startArgs();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.startsWith("--")) {
                acceptor.acceptKey(arg.substring(2));
                continue;
            }
            acceptor.acceptValue(arg);
        }
        acceptor.endArgs();
        return acceptor.buildIndex();
    }

    private static ArgumentIndex indexMap(Map<String, String> options) {
        ArgsAcceptor acceptor = new ArgsAcceptor();
        acceptor.startArgs();
        for (Map.Entry<String, String> option : options.entrySet()) {
            acceptor.acceptKey(option.getKey());
            acceptor.acceptValue(option.getValue());
        }
        acceptor.endArgs();
        return acceptor.buildIndex();
    }

    static void emitError(String message, Object ... args) {
        if (collectErrors) {
            errors.add(Error.create(message, args));
        }
    }

    private static String getCallerClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String myType = Flags.class.getCanonicalName();
        String threadType = Thread.class.getCanonicalName();
        for (StackTraceElement e : stackTrace) {
            if (e.getClassName().equals(myType) || e.getClassName().equals(threadType)) continue;
            return e.getClassName();
        }
        return null;
    }

    static {
        flagIndex = new FlagIndex();
        flagMetadataIndex = new FlagIndex();
        classMetadataIndex = new ClassMetadataIndex();
        errors = new ArrayList<Error>();
        collectErrors = false;
        classScanner = new ClassScanner();
    }

    public static abstract class Error {
        public static Error create(String message, Object[] parameters) {
            return new AutoValue_Flags_Error(message, parameters);
        }

        public abstract String message();

        protected abstract Object varargs();

        public final Object[] parameters() {
            return (Object[])this.varargs();
        }

        public final String toString() {
            return String.format(this.message(), this.parameters());
        }
    }

    static class ArgumentIndex {
        private final ImmutableMultimap<String, String> argumentValues;

        public ArgumentIndex(ImmutableMultimap<String, String> argumentValues) {
            this.argumentValues = argumentValues;
        }

        public Collection<String> all(String className, String flagName) {
            ImmutableCollection ret = this.argumentValues.get((Object)(className + '.' + flagName));
            if (ret == null || ret.isEmpty()) {
                ret = this.argumentValues.get((Object)flagName);
            }
            return ret;
        }

        public String single(String className, String flagName) {
            Iterator<String> iter;
            Collection<String> ret = this.all(className, flagName);
            if (ret != null && (iter = ret.iterator()).hasNext()) {
                return iter.next();
            }
            return null;
        }
    }

    static class ArgsAcceptor {
        private AcceptorState state;
        private String _key;
        private final Multimap<String, String> arguments = ArrayListMultimap.create();

        ArgsAcceptor() {
        }

        void startArgs() {
            this.state = AcceptorState.KEY_EXPECTED;
        }

        void acceptKey(String key) {
            if (this.state != AcceptorState.KEY_EXPECTED) {
                Flags.emitError("Each option is a key-value pair, option " + this._key + " is followed directly by " + key, new Object[0]);
            }
            this._key = key;
            this.state = AcceptorState.VALUE_EXPECTED;
        }

        void acceptValue(String value) {
            if (this.state == AcceptorState.VALUE_EXPECTED) {
                this.arguments.put((Object)this._key, (Object)value);
                this.state = AcceptorState.KEY_EXPECTED;
            } else {
                Flags.emitError("Each option is a key value pair, key has been omitted before argument '" + value + "'", new Object[0]);
            }
        }

        void endArgs() {
            if (this.state != AcceptorState.KEY_EXPECTED) {
                Flags.emitError("Each option is a key-value pair, option " + this._key + " is the last arguments", new Object[0]);
            }
        }

        ArgumentIndex buildIndex() {
            return new ArgumentIndex((ImmutableMultimap<String, String>)ImmutableMultimap.copyOf(this.arguments));
        }

        static enum AcceptorState {
            KEY_EXPECTED,
            VALUE_EXPECTED;

        }
    }
}

