/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.function.Function;

public class TypeConversion {
    private HashMap<Class<?>, Function<String, ?>> typeConversions = Maps.newHashMap();
    private final ImmutableMap DEFAULT_CONVERSIONS = ImmutableMap.builder().put(String.class, (Object)new Conversion<String>(){

        @Override
        public String apply(String s) {
            return s;
        }
    }).put(Integer.class, (Object)new Conversion<Integer>(){

        @Override
        public Integer apply(String s) {
            return Integer.parseInt(s);
        }
    }).put(Float.class, (Object)new Conversion<Float>(){

        @Override
        public Float apply(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }
    }).put(Double.class, (Object)new Conversion<Double>(){

        @Override
        public Double apply(String s) {
            return Double.parseDouble(s);
        }
    }).put(BigInteger.class, (Object)new Conversion<BigInteger>(){

        @Override
        public BigInteger apply(String s) {
            return new BigInteger(s);
        }
    }).put(BigDecimal.class, (Object)new Conversion<BigDecimal>(){

        @Override
        public BigDecimal apply(String s) {
            return new BigDecimal(s);
        }
    }).build();

    public <T> Conversion<T> forType(Class<T> type) {
        return this.typeConversions.containsKey(type) ? (Conversion)((Object)this.typeConversions.get(type)) : (Conversion)this.DEFAULT_CONVERSIONS.get(type);
    }

    public <T> void register(Class<T> type, Function<String, T> conversion) {
        this.typeConversions.put(type, conversion);
    }

    public <T> void unregister(Class<T> type) {
        this.typeConversions.remove(type);
    }

    public static interface Conversion<T> {
        public T apply(String var1);
    }
}

