/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.github.yin.flags.ArgumentProvider;
import com.github.yin.flags.ClassMetadataIndex;
import com.github.yin.flags.Flag;
import com.github.yin.flags.FlagID;
import com.github.yin.flags.FlagIndex;
import com.github.yin.flags.FlagMetadata;
import com.github.yin.flags.TypeConversion;
import com.github.yin.flags.analysis.UsagePrinter;
import com.github.yin.flags.annotations.ClassScanner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flags
implements ArgumentProvider {
    private static Flags instance;
    private final ClassScanner classScanner;
    private final ClassMetadataIndex classMetadataIndex;
    private final FlagIndex<Flag<?>> flagIndex;
    private final FlagIndex<FlagMetadata> flagMetadataIndex;
    private ArgumentIndex argumentIndex = ArgumentIndex.EMPTY;
    private final TypeConversion typeConversion;

    public static void init(String[] args) {
        Flags.instance().indexArguments(args);
    }

    public static Flag<String> string(String name) {
        return Flags.create(String.class, name);
    }

    public static <T> Flag<T> create(Class<T> type, String name) {
        return Flags.instance().createFlag(type, name);
    }

    private <T> Flag<T> createFlag(Class<T> type, String name) {
        try {
            String callerClass = this.scanCallerClass();
            FlagID id = FlagID.create(callerClass, name);
            Flag flag = Flag.create(id, type, this, this.typeConversion);
            this.flagIndex.add(id, flag);
            return flag;
        }
        catch (ClassNotFoundException ex) {
            Throwables.propagate((Throwable)ex);
            return null;
        }
    }

    public static void printUsage(String packagePrefix) {
        Flags.instance().printUsageForPackage(packagePrefix);
    }

    @VisibleForTesting
    public static void initForTesting(Map<String, String> options) {
        Flags.instance().indexMap(options);
    }

    @VisibleForTesting
    static ClassMetadataIndex classMetadata() {
        return Flags.instance().classMetadataIndex;
    }

    @VisibleForTesting
    static FlagIndex flagMetadata() {
        return Flags.instance().flagMetadataIndex;
    }

    public static void clear() {
        Flags.instance().clearArguments();
    }

    @Override
    public ArgumentIndex arguments() {
        return this.argumentIndex;
    }

    public TypeConversion getTypeConversion() {
        return this.typeConversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printUsageForPackage(String packageProfix) {
        Flags flags = this;
        synchronized (flags) {
            this.classScanner.scanPackage(packageProfix, this.flagMetadataIndex, this.classMetadataIndex);
        }
        new UsagePrinter().printUsage(this.flagMetadataIndex, this.classMetadataIndex, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String scanCallerClass() throws ClassNotFoundException {
        String className = this.getCallerClassName();
        Flags flags = this;
        synchronized (flags) {
            this.classScanner.scanClass(className, this.flagMetadataIndex, this.classMetadataIndex);
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Flags instance() {
        Class<Flags> clazz = Flags.class;
        synchronized (Flags.class) {
            if (instance == null) {
                instance = new Flags(new ClassScanner(), new ClassMetadataIndex(), new FlagIndex(), new FlagIndex<FlagMetadata>(), new TypeConversion());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Flags(ClassScanner classScanner, ClassMetadataIndex classMetadataIndex, FlagIndex<Flag<?>> flagIndex, FlagIndex<FlagMetadata> flagMetadataIndex, TypeConversion typeConversion) {
        this.classScanner = classScanner;
        this.classMetadataIndex = classMetadataIndex;
        this.flagIndex = flagIndex;
        this.flagMetadataIndex = flagMetadataIndex;
        this.argumentIndex = ArgumentIndex.EMPTY;
        this.typeConversion = typeConversion;
    }

    private void indexArguments(String[] args) {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])args);
        ArgsAcceptor acceptor = new ArgsAcceptor();
        acceptor.start();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.startsWith("--")) {
                acceptor.key(arg.substring(2));
                continue;
            }
            acceptor.value(arg);
        }
        acceptor.end();
        this.argumentIndex = acceptor.buildIndex();
    }

    private void indexMap(Map<String, String> options) {
        ArgsAcceptor acceptor = new ArgsAcceptor();
        acceptor.start();
        for (Map.Entry<String, String> option : options.entrySet()) {
            acceptor.key(option.getKey());
            acceptor.value(option.getValue());
        }
        acceptor.end();
        this.argumentIndex = acceptor.buildIndex();
    }

    private String getCallerClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String myType = Flags.class.getCanonicalName();
        String threadType = Thread.class.getCanonicalName();
        for (StackTraceElement e : stackTrace) {
            if (e.getClassName().equals(myType) || e.getClassName().equals(threadType)) continue;
            return e.getClassName();
        }
        return null;
    }

    private void clearArguments() {
        this.argumentIndex = ArgumentIndex.EMPTY;
    }

    static class ArgumentIndex {
        public static final ArgumentIndex EMPTY = new ArgumentIndex((ImmutableMultimap<String, String>)ImmutableMultimap.of());
        private final ImmutableMultimap<String, String> argumentValues;

        public ArgumentIndex(ImmutableMultimap<String, String> argumentValues) {
            this.argumentValues = argumentValues;
        }

        public Collection<String> all(FlagID flagID) {
            ImmutableCollection ret = this.argumentValues.get((Object)(flagID.className() + '.' + flagID.flagName()));
            if (ret == null || ret.isEmpty()) {
                ret = this.argumentValues.get((Object)flagID.flagName());
            }
            return ret;
        }

        public String single(FlagID flagID) {
            Iterator<String> iter;
            Collection<String> ret = this.all(flagID);
            if (ret != null && (iter = ret.iterator()).hasNext()) {
                return iter.next();
            }
            return null;
        }
    }

    static class ArgsAcceptor {
        private static final Logger log = LoggerFactory.getLogger(ArgsAcceptor.class);
        private final Multimap<String, String> arguments = ArrayListMultimap.create();
        private AcceptorState state;
        private String _key;

        ArgsAcceptor() {
        }

        void start() {
            this.state = AcceptorState.KEY_EXPECTED;
        }

        void key(String key) {
            if (this.state != AcceptorState.KEY_EXPECTED) {
                log.error("Option {} has no value", (Object)this._key);
            }
            this._key = key;
            this.state = AcceptorState.VALUE_EXPECTED;
        }

        void value(String value) {
            if (this.state == AcceptorState.VALUE_EXPECTED) {
                this.arguments.put((Object)this._key, (Object)value);
                this.state = AcceptorState.KEY_EXPECTED;
            } else {
                log.error("No option before argument '{}' (temporary rule)", (Object)value);
            }
        }

        void end() {
            if (this.state != AcceptorState.KEY_EXPECTED) {
                log.error("Option {} has no value", (Object)this._key);
            }
        }

        ArgumentIndex buildIndex() {
            return new ArgumentIndex((ImmutableMultimap<String, String>)ImmutableMultimap.copyOf(this.arguments));
        }

        static enum AcceptorState {
            KEY_EXPECTED,
            VALUE_EXPECTED;

        }
    }
}

