/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.github.yin.flags.BasicFlag;
import com.github.yin.flags.ClassMetadataIndex;
import com.github.yin.flags.Flag;
import com.github.yin.flags.FlagIndex;
import com.github.yin.flags.FlagMetadata;
import com.github.yin.flags.GflagsParser;
import com.github.yin.flags.MapParser;
import com.github.yin.flags.analysis.UsagePrinter;
import com.github.yin.flags.annotations.ClassScanner;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class Flags {
    private static Flags instance;
    private final ClassScanner classScanner;
    private final ClassMetadataIndex classMetadataIndex;
    private final FlagIndex<FlagMetadata> flagIndex;

    public static List<String> parse(String[] args, Iterable<String> packages) {
        Flags.instance().scan(packages);
        return instance._parse(args);
    }

    public static Flag<Boolean> create(Boolean defaultz) {
        return new BasicFlag.BooleanFlag(defaultz);
    }

    public static Flag<Integer> create(Integer defaultz) {
        return new BasicFlag.IntegerFlag(defaultz);
    }

    public static Flag<Long> create(Long defaultz) {
        return new BasicFlag.LongFlag(defaultz);
    }

    public static Flag<Float> create(Float defaultz) {
        return new BasicFlag.FloatFlag(defaultz);
    }

    public static Flag<Double> create(Double defaultz) {
        return new BasicFlag.DoubleFlag(defaultz);
    }

    public static Flag<BigInteger> create(BigInteger defaultz) {
        return new BasicFlag.BigIntegerFlag(defaultz);
    }

    public static Flag<BigDecimal> create(BigDecimal defaultz) {
        return new BasicFlag.BigDecimalFlag(defaultz);
    }

    public static Flag<String> create(String defaultz) {
        return new BasicFlag.StringFlag(defaultz);
    }

    public static void printUsage(String packagePrefix) {
        Flags.instance().printUsageForPackage(packagePrefix);
    }

    @VisibleForTesting
    public static void parse(Map<String, String> options, Iterable<String> packages) {
        Flags.instance().scan(packages);
        Flags.instance()._parse(options);
    }

    @VisibleForTesting
    static ClassMetadataIndex classMetadata() {
        return Flags.instance().classMetadataIndex;
    }

    @VisibleForTesting
    static FlagIndex flagMetadata() {
        return Flags.instance().flagIndex;
    }

    private void scan(Iterable<String> packages) {
        for (String pkg : packages) {
            this.classScanner.scanPackage(pkg, this.flagIndex, this.classMetadataIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printUsageForPackage(String packagePrefix) {
        Flags flags = this;
        synchronized (flags) {
            this.classScanner.scanPackage(packagePrefix, this.flagIndex, this.classMetadataIndex);
        }
        new UsagePrinter().printUsage(this.flagIndex, this.classMetadataIndex, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Flags instance() {
        Class<Flags> clazz = Flags.class;
        synchronized (Flags.class) {
            if (instance == null) {
                instance = new Flags(new ClassScanner(), new ClassMetadataIndex(), new FlagIndex<FlagMetadata>());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Flags(ClassScanner classScanner, ClassMetadataIndex classMetadataIndex, FlagIndex<FlagMetadata> flagIndex) {
        this.classScanner = classScanner;
        this.classMetadataIndex = classMetadataIndex;
        this.flagIndex = flagIndex;
    }

    private List<String> _parse(String[] args) {
        GflagsParser parser = new GflagsParser(this.flagIndex);
        return parser.parse(args);
    }

    private void _parse(Map<String, String> options) {
        MapParser parser = new MapParser(this.flagIndex);
        parser.parse(options);
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public ParseException(String message) {
            super(message);
        }
    }
}

