/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.github.yin.flags.BasicFlag;
import com.github.yin.flags.FlagIndex;
import com.github.yin.flags.FlagMetadata;
import com.github.yin.flags.Parser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GflagsParser
implements Parser<String[]> {
    private static final Logger log = LoggerFactory.getLogger(GflagsParser.class);
    private final List<String> arguments = new ArrayList<String>();
    private final FlagIndex<FlagMetadata> flags;
    private AcceptorState state;
    private FlagMetadata lastMeta;

    public GflagsParser(@Nonnull FlagIndex<FlagMetadata> flags) {
        this.flags = flags;
    }

    @Override
    public List<String> parse(String[] args) {
        this.start();
        for (String arg : args) {
            this.next(arg);
        }
        return this.end();
    }

    protected void start() {
        this.state = AcceptorState.KEY_EXPECTED;
    }

    protected void next(String arg) {
        if (arg.startsWith("--")) {
            this.flag(arg.substring(2), arg);
        } else if (arg.startsWith("-")) {
            this.flag(arg.substring(1), arg);
        } else {
            this.handleValue(arg);
        }
    }

    protected void flag(String flag, String orig) {
        int i = flag.indexOf(61);
        if (i == -1) {
            this.key(flag, orig);
        } else {
            String key = flag.substring(0, i);
            String value = flag.substring(i + 1, flag.length() - i - 1);
            this.keyAndValue(key, value, orig);
        }
    }

    protected void key(String key, String original) {
        Collection flagsByName;
        if (this.state != AcceptorState.KEY_EXPECTED) {
            this.errorFlagHasNoValue();
        }
        if ((flagsByName = this.flags.byName().get((Object)key)).isEmpty() && key.startsWith("no")) {
            flagsByName = this.flags.byName().get((Object)key.substring(2));
            if (flagsByName.size() == 1) {
                this.handleFalseFlag((FlagMetadata)flagsByName.iterator().next(), original);
            } else if (flagsByName.isEmpty()) {
                this.errorUnknownFlag(original);
            } else {
                this.errorAmbigousFlag(original, flagsByName);
            }
        }
        if (flagsByName.size() == 1) {
            this.handleFlag((FlagMetadata)flagsByName.iterator().next());
        } else if (flagsByName.isEmpty()) {
            this.errorUnknownFlag(original);
        } else {
            this.errorAmbigousFlag(original, flagsByName);
        }
    }

    protected void keyAndValue(String key, String value, String original) {
        Collection flagsByName;
        if (this.state != AcceptorState.KEY_EXPECTED) {
            this.errorFlagHasNoValue();
        }
        if ((flagsByName = this.flags.byName().get((Object)key)).size() == 1) {
            this.handleFlag((FlagMetadata)flagsByName.iterator().next());
            this.handleValue(value);
        } else if (flagsByName.isEmpty()) {
            this.errorUnknownFlag(original);
        } else {
            this.errorAmbigousFlag(original, flagsByName);
        }
    }

    protected void handleFlag(FlagMetadata meta) {
        Class<?> flagtype = meta.getClass();
        if (BasicFlag.BooleanFlag.class.isAssignableFrom(flagtype)) {
            meta.flag().parse("true");
        } else {
            this.lastMeta = meta;
            this.state = AcceptorState.VALUE_EXPECTED;
        }
    }

    protected void handleFalseFlag(FlagMetadata meta, String orig) {
        Class<?> flagtype = meta.getClass();
        if (BasicFlag.BooleanFlag.class.isAssignableFrom(flagtype)) {
            meta.flag().parse("false");
        } else {
            this.errorUnknownFlag(orig);
        }
    }

    protected void handleValue(String value) {
        if (this.state == AcceptorState.VALUE_EXPECTED) {
            this.lastMeta.flag().parse(value);
            this.state = AcceptorState.KEY_EXPECTED;
        } else {
            this.arguments.add(value);
        }
    }

    protected List<String> end() {
        if (this.state != AcceptorState.KEY_EXPECTED) {
            this.errorFlagHasNoValue();
        }
        return this.arguments;
    }

    protected void errorUnknownFlag(String flag) {
        log.error("Unknown flag: {}", (Object)flag);
    }

    protected void errorAmbigousFlag(String flag, Collection<FlagMetadata> flagsByName) {
        log.error("Flag {} resolves in multiple classes: {}", (Object)flag, (Object)flagsByName.stream().map(meta -> meta.flagID()).toArray());
    }

    protected void errorFlagHasNoValue() {
        log.error("Option {} has no value", (Object)this.lastMeta);
    }

    static enum AcceptorState {
        KEY_EXPECTED,
        VALUE_EXPECTED;

    }
}

