/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags;

import com.github.yin.flags.FlagIndex;
import com.github.yin.flags.FlagMetadata;
import com.github.yin.flags.GflagsParser;
import com.github.yin.flags.Parser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapParser
implements Parser<Map<String, String>> {
    private static final Logger log = LoggerFactory.getLogger(GflagsParser.class);
    private final FlagIndex<FlagMetadata> flags;

    public MapParser(@Nonnull FlagIndex<FlagMetadata> flags) {
        this.flags = flags;
    }

    @Override
    public List<String> parse(Map<String, String> args) {
        for (Map.Entry<String, String> arg : args.entrySet()) {
            this.next(arg.getKey(), arg.getValue());
        }
        return Collections.EMPTY_LIST;
    }

    protected void next(String key, String value) {
        Collection flagsByName = this.flags.byName().get((Object)key);
        if (flagsByName.size() == 1) {
            ((FlagMetadata)flagsByName.iterator().next()).flag().parse(value);
        } else if (flagsByName.isEmpty()) {
            this.errorUnknownFlag(key);
        } else {
            this.errorAmbigousFlag(key, flagsByName);
        }
    }

    protected void errorUnknownFlag(String flag) {
        log.error("Unknown flag: {}", (Object)flag);
    }

    protected void errorAmbigousFlag(String flag, Collection<FlagMetadata> flagsByName) {
        log.error("Flag {} resolves in multiple classes: {}", (Object)flag, (Object)flagsByName.stream().map(meta -> meta.flagID()).toArray());
    }
}

