/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.flags.annotations;

import com.github.yin.flags.ClassMetadata;
import com.github.yin.flags.ClassMetadataIndex;
import com.github.yin.flags.Flag;
import com.github.yin.flags.FlagIndex;
import com.github.yin.flags.FlagMetadata;
import com.github.yin.flags.Flags;
import com.github.yin.flags.annotations.FlagDesc;
import java.lang.reflect.Field;
import java.util.Set;
import org.reflections.Reflections;

public class ClassScanner {
    public void scanPackage(String packagePrefix, FlagIndex<FlagMetadata> flags, ClassMetadataIndex classMetaIndex) {
        new Scanner(new Reflections(packagePrefix, new org.reflections.scanners.Scanner[0])).scanPackage(flags, classMetaIndex);
    }

    private class Scanner {
        private Reflections reflections;

        public Scanner(Reflections reflections) {
            this.reflections = reflections;
        }

        public Scanner scanClass(Class<?> parent, FlagIndex<FlagMetadata> flags, ClassMetadataIndex classMetadataIndex) {
            this.collectClassMetadata(parent, classMetadataIndex);
            this.collectFields(parent, flags);
            return this;
        }

        public Scanner scanPackage(FlagIndex<FlagMetadata> flags, ClassMetadataIndex classMetaIndex) {
            Set classDescs = this.reflections.getTypesAnnotatedWith(FlagDesc.class);
            for (Class clazz : classDescs) {
                this.scanClass(clazz, flags, classMetaIndex);
            }
            return this;
        }

        private void collectClassMetadata(Class<?> parent, ClassMetadataIndex classMetadataIndex) {
            FlagDesc[] flagDescs = (FlagDesc[])parent.getAnnotationsByType(FlagDesc.class);
            if (flagDescs.length > 1) {
                throw new Flags.ParseException("Class " + parent.getCanonicalName() + " is annotated multiple times with @FlagDesc");
            }
            for (FlagDesc desc : flagDescs) {
                ClassMetadata classInfo = ClassMetadata.create(parent.getCanonicalName(), desc.value());
                classMetadataIndex.classes().put(parent.getCanonicalName(), classInfo);
            }
        }

        public void collectFields(Class<?> parent, FlagIndex<FlagMetadata> metadata) {
            Field[] fields;
            for (Field field : fields = parent.getDeclaredFields()) {
                Class<?> clazz = field.getType();
                if (!Flag.class.isAssignableFrom(clazz)) continue;
                if ((field.getModifiers() & 8) == 0) {
                    throw new Flags.ParseException("Flag " + clazz.getCanonicalName() + "." + field.getName() + " is not a static field");
                }
                Flag<?> flag = this.getFlag(parent, field);
                FlagMetadata meta = this.createMeta(parent, field, flag);
                metadata.add(meta.flagID(), meta);
            }
        }

        private FlagMetadata createMeta(Class<?> parent, Field field, Flag<?> flag) {
            FlagDesc[] flagDescs = (FlagDesc[])field.getAnnotationsByType(FlagDesc.class);
            if (flagDescs.length == 0) {
                return FlagMetadata.create(parent.getCanonicalName(), field.getName(), "", flag);
            }
            if (flagDescs.length == 1) {
                FlagDesc desc = flagDescs[0];
                String name = desc.name().isEmpty() ? field.getName() : desc.name();
                return FlagMetadata.create(parent.getCanonicalName(), name, desc.value(), flag);
            }
            throw new Flags.ParseException("Flag " + parent.getCanonicalName() + "." + field.getName() + " is annotated multiple times with @FlagDesc");
        }

        private Flag<?> getFlag(Class<?> parent, Field field) {
            try {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                Object value = field.get(parent);
                field.setAccessible(accessible);
                if (value == null || !Flag.class.isAssignableFrom(value.getClass())) {
                    throw new Flags.ParseException("Flag " + parent.getCanonicalName() + "." + field.getName() + " is not of type Flag<?>");
                }
                return (Flag)value;
            }
            catch (IllegalAccessException e) {
                throw new Flags.ParseException("Flag " + parent.getCanonicalName() + "." + field.getName() + " is not accessible", e);
            }
        }
    }
}

