/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.test.framework;

import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;

class SingleJUnitTestRunner {
    SingleJUnitTestRunner() {
    }

    static void main(String ... args) {
        if (args.length < 1) {
            throw new MissingRequiredArgException("Missing the JUnit class name argument.");
        }
        String className = args[0];
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JUnitClassNotFoundException(String.format("JUnit test class %s is not found.", className));
        }
        Result result = new JUnitCore().run(Request.aClass(clazz));
        if (!result.wasSuccessful()) {
            System.out.println("Tests have failures: " + result.getFailures());
        }
    }

    static class MissingRequiredArgException
    extends RuntimeException {
        MissingRequiredArgException(String errorMessage) {
            super(errorMessage);
        }
    }

    static class JUnitClassNotFoundException
    extends RuntimeException {
        JUnitClassNotFoundException(String errorMessage) {
            super(errorMessage);
        }
    }
}

