/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.test.protoloader;

import com.google.api.Service;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.Transport;
import com.google.api.generator.gapic.protoparser.BatchingSettingsConfigParser;
import com.google.api.generator.gapic.protoparser.Parser;
import com.google.api.generator.gapic.protoparser.ServiceConfigParser;
import com.google.api.generator.gapic.protoparser.ServiceYamlParser;
import com.google.api.version.test.ApiVersionTestingOuterClass;
import com.google.auto.populate.field.AutoPopulateFieldTestingOuterClass;
import com.google.bookshop.v1beta1.BookshopProto;
import com.google.cloud.bigquery.v2.JobProto;
import com.google.explicit.dynamic.routing.header.ExplicitDynamicRoutingHeaderTestingOuterClass;
import com.google.logging.v2.LogEntryProto;
import com.google.logging.v2.LoggingConfigProto;
import com.google.logging.v2.LoggingMetricsProto;
import com.google.logging.v2.LoggingProto;
import com.google.protobuf.Descriptors;
import com.google.pubsub.v1.PubsubProto;
import com.google.selective.generate.v1beta1.SelectiveApiGenerationOuterClass;
import com.google.showcase.v1beta1.EchoOuterClass;
import com.google.showcase.v1beta1.IdentityOuterClass;
import com.google.showcase.v1beta1.MessagingOuterClass;
import com.google.showcase.v1beta1.TestingOuterClass;
import com.google.test.callablenamingtype.CallableNameType;
import com.google.testdata.v1.DeprecatedServiceOuterClass;
import com.google.testgapic.v1beta1.NestedMessageProto;
import com.google.types.testing.TypesTestingProto;
import google.cloud.CommonResources;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;

public class TestProtoLoader {
    private static final TestProtoLoader INSTANCE = new TestProtoLoader(Transport.GRPC, "src/test/resources/");
    private static final String ECHO_SERVICE_DESCRIPTION = "This service is used showcase the four main types of rpcs - unary, server\n side streaming, client side streaming, and bidirectional streaming. This\n service also exposes methods that explicitly implement server delay, and\n paginated calls. Set the 'showcase-trailer' metadata key on any method\n to have the values echoed in the response trailers.";
    private final String testFilesDirectory;
    private final Transport transport;

    protected TestProtoLoader(Transport transport, String testFilesDirectory) {
        this.testFilesDirectory = testFilesDirectory;
        this.transport = transport;
    }

    public static TestProtoLoader instance() {
        return INSTANCE;
    }

    public GapicContext parseDeprecatedService() {
        Descriptors.FileDescriptor fileDescriptor = DeprecatedServiceOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)fileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"DeprecatedService", (Object)serviceDescriptor.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor);
        HashMap resourceNames = new HashMap();
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)fileDescriptor, (Map)messageTypes, resourceNames, Optional.empty(), outputResourceNames);
        String jsonFilename = "deprecated_service_grpc_service_config.json";
        Path jsonPath = Paths.get(this.testFilesDirectory, jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseBookshopService() {
        Descriptors.FileDescriptor fileDescriptor = BookshopProto.getDescriptor();
        Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)fileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Bookshop", (Object)serviceDescriptor.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor);
        HashMap resourceNames = new HashMap();
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)fileDescriptor, (Map)messageTypes, resourceNames, Optional.empty(), outputResourceNames);
        String jsonFilename = "bookshop_grpc_service_config.json";
        Path jsonPath = Paths.get(this.testFilesDirectory, jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseNestedMessage() {
        Descriptors.FileDescriptor fileDescriptor = TypesTestingProto.getDescriptor();
        Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)fileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"NestedMessageService", (Object)serviceDescriptor.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor);
        Descriptors.FileDescriptor messageFileDescriptor = NestedMessageProto.getDescriptor();
        messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)messageFileDescriptor));
        HashMap resourceNames = new HashMap();
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)fileDescriptor, (Map)messageTypes, resourceNames, Optional.empty(), outputResourceNames);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseShowcaseEcho() {
        Descriptors.FileDescriptor echoFileDescriptor = EchoOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor echoServiceDescriptor = (Descriptors.ServiceDescriptor)echoFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Echo", (Object)echoServiceDescriptor.getName());
        String serviceYamlFilename = "echo_v1beta1.yaml";
        Path serviceYamlPath = Paths.get(this.testFilesDirectory, serviceYamlFilename);
        Optional serviceYamlOpt = ServiceYamlParser.parse((String)serviceYamlPath.toString());
        Assert.assertTrue((boolean)serviceYamlOpt.isPresent());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)echoFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)echoFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)echoFileDescriptor, (Map)messageTypes, (Map)resourceNames, (Optional)serviceYamlOpt, outputResourceNames);
        List servicesWithDescription = services.stream().map(s -> s.toBuilder().setDescription(ECHO_SERVICE_DESCRIPTION).build()).collect(Collectors.toList());
        String jsonFilename = "showcase_grpc_service_config.json";
        Path jsonPath = Paths.get(this.testFilesDirectory, jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(servicesWithDescription).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseShowcaseIdentity() {
        Descriptors.FileDescriptor fileDescriptor = IdentityOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor identityService = (Descriptors.ServiceDescriptor)fileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Identity", (Object)identityService.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)fileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)fileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseShowcaseMessaging() {
        Descriptors.FileDescriptor fileDescriptor = MessagingOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor messagingService = (Descriptors.ServiceDescriptor)fileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Messaging", (Object)messagingService.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)fileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)fileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseShowcaseTesting() {
        Descriptors.FileDescriptor testingFileDescriptor = TestingOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor testingService = (Descriptors.ServiceDescriptor)testingFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Testing", (Object)testingService.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)testingFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)testingFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)testingFileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseExplicitDynamicRoutingHeaderTesting() {
        Descriptors.FileDescriptor testingFileDescriptor = ExplicitDynamicRoutingHeaderTestingOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor testingService = (Descriptors.ServiceDescriptor)testingFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"ExplicitDynamicRoutingHeaderTesting", (Object)testingService.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)testingFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)testingFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)testingFileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseApiVersionTesting() {
        Descriptors.FileDescriptor testingFileDescriptor = ApiVersionTestingOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor testingService = (Descriptors.ServiceDescriptor)testingFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"EchoWithVersion", (Object)testingService.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)testingFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)testingFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)testingFileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        String jsonFilename = "showcase_grpc_service_config.json";
        Path jsonPath = Paths.get(this.testFilesDirectory, jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseAutoPopulateFieldTesting() {
        Descriptors.FileDescriptor autopopulationFileDescriptor = AutoPopulateFieldTestingOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor autopopulationServiceDescriptor = (Descriptors.ServiceDescriptor)autopopulationFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"AutoPopulateFieldTesting", (Object)autopopulationServiceDescriptor.getName());
        String serviceYamlFilename = "auto_populate_field_testing.yaml";
        Path serviceYamlPath = Paths.get(this.testFilesDirectory, serviceYamlFilename);
        Optional serviceYamlOpt = ServiceYamlParser.parse((String)serviceYamlPath.toString());
        Assert.assertTrue((boolean)serviceYamlOpt.isPresent());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)autopopulationFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)autopopulationFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)autopopulationFileDescriptor, (Map)messageTypes, (Map)resourceNames, (Optional)serviceYamlOpt, outputResourceNames);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseSelectiveGenerationTesting() {
        Descriptors.FileDescriptor selectiveGenerationFileDescriptor = SelectiveApiGenerationOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor selectiveGenerationServiceDescriptor = (Descriptors.ServiceDescriptor)selectiveGenerationFileDescriptor.getServices().get(1);
        Assert.assertEquals((Object)"EchoServiceShouldGeneratePartialUsual", (Object)selectiveGenerationServiceDescriptor.getName());
        String serviceYamlFilename = "selective_api_generation_generate_omitted_v1beta1.yaml";
        Path serviceYamlPath = Paths.get(this.testFilesDirectory, serviceYamlFilename);
        Optional serviceYamlOpt = ServiceYamlParser.parse((String)serviceYamlPath.toString());
        Assert.assertTrue((boolean)serviceYamlOpt.isPresent());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)selectiveGenerationFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)selectiveGenerationFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)selectiveGenerationFileDescriptor, (Map)messageTypes, (Map)resourceNames, (Optional)serviceYamlOpt, outputResourceNames);
        String jsonFilename = "selective_api_generation_grpc_service_config.json";
        Path jsonPath = Paths.get(this.testFilesDirectory, jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setServiceYamlProto((Service)serviceYamlOpt.orElse(null)).setGapicMetadataEnabled(true).setServiceConfig(config).setTransport(this.transport).build();
    }

    public GapicContext parsePubSubPublisher() {
        Descriptors.FileDescriptor serviceFileDescriptor = PubsubProto.getDescriptor();
        Descriptors.FileDescriptor commonResourcesFileDescriptor = CommonResources.getDescriptor();
        Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)serviceFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Publisher", (Object)serviceDescriptor.getName());
        HashMap resourceNames = new HashMap();
        resourceNames.putAll(Parser.parseResourceNames((Descriptors.FileDescriptor)serviceFileDescriptor));
        resourceNames.putAll(Parser.parseResourceNames((Descriptors.FileDescriptor)commonResourcesFileDescriptor));
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)serviceFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)serviceFileDescriptor, (Map)messageTypes, resourceNames, Optional.empty(), outputResourceNames);
        String filename = "pubsub_gapic.yaml";
        Path path = Paths.get(this.getTestFilesDirectory(), filename);
        Optional batchingSettingsOpt = BatchingSettingsConfigParser.parse(Optional.of(path.toString()));
        Assert.assertTrue((boolean)batchingSettingsOpt.isPresent());
        String jsonFilename = "pubsub_grpc_service_config.json";
        Path jsonPath = Paths.get(this.getTestFilesDirectory(), jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        config.setBatchingSettings(batchingSettingsOpt);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseLogging() {
        Descriptors.FileDescriptor serviceFileDescriptor = LoggingProto.getDescriptor();
        Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)serviceFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"LoggingServiceV2", (Object)serviceDescriptor.getName());
        List<Descriptors.FileDescriptor> protoFiles = Arrays.asList(serviceFileDescriptor, LogEntryProto.getDescriptor(), LoggingConfigProto.getDescriptor(), LoggingMetricsProto.getDescriptor());
        HashMap resourceNames = new HashMap();
        HashMap messageTypes = new HashMap();
        for (Descriptors.FileDescriptor fileDescriptor : protoFiles) {
            resourceNames.putAll(Parser.parseResourceNames((Descriptors.FileDescriptor)fileDescriptor));
            messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor));
        }
        Descriptors.FileDescriptor commonResourcesFileDescriptor = CommonResources.getDescriptor();
        resourceNames.putAll(Parser.parseResourceNames((Descriptors.FileDescriptor)commonResourcesFileDescriptor));
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)serviceFileDescriptor, messageTypes, resourceNames, Optional.empty(), outputResourceNames);
        String filename = "logging_gapic.yaml";
        Path path = Paths.get(this.getTestFilesDirectory(), filename);
        Optional batchingSettingsOpt = BatchingSettingsConfigParser.parse(Optional.of(path.toString()));
        Assert.assertTrue((boolean)batchingSettingsOpt.isPresent());
        String jsonFilename = "logging_grpc_service_config.json";
        Path jsonPath = Paths.get(this.getTestFilesDirectory(), jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        config.setBatchingSettings(batchingSettingsOpt);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseCallabeNameType() {
        Descriptors.FileDescriptor serviceFileDescriptor = CallableNameType.getDescriptor();
        Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)serviceFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"CallableNameTypeService", (Object)serviceDescriptor.getName());
        List<Descriptors.FileDescriptor> protoFiles = Collections.singletonList(serviceFileDescriptor);
        HashMap resourceNames = new HashMap();
        HashMap messageTypes = new HashMap();
        for (Descriptors.FileDescriptor fileDescriptor : protoFiles) {
            resourceNames.putAll(Parser.parseResourceNames((Descriptors.FileDescriptor)fileDescriptor));
            messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor));
        }
        Descriptors.FileDescriptor commonResourcesFileDescriptor = CommonResources.getDescriptor();
        resourceNames.putAll(Parser.parseResourceNames((Descriptors.FileDescriptor)commonResourcesFileDescriptor));
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)serviceFileDescriptor, messageTypes, resourceNames, Optional.empty(), outputResourceNames);
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public GapicContext parseBigqueryService() {
        Descriptors.FileDescriptor bigqueryFileDescriptor = JobProto.getDescriptor();
        Descriptors.ServiceDescriptor biqqueryServiceDescriptor = (Descriptors.ServiceDescriptor)bigqueryFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"JobService", (Object)biqqueryServiceDescriptor.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)bigqueryFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)bigqueryFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)bigqueryFileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        String jsonFilename = "bigquery_v2_service_config.json";
        Path jsonPath = Paths.get(this.testFilesDirectory, jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.transport).build();
    }

    public String getTestFilesDirectory() {
        return this.testFilesDirectory;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

