/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.examples;

import com.google.gcloud.AuthCredentials;
import com.google.gcloud.RetryParams;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.BatchRequest;
import com.google.gcloud.storage.BatchResponse;
import com.google.gcloud.storage.Blob;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.BlobReadChannel;
import com.google.gcloud.storage.BlobWriteChannel;
import com.google.gcloud.storage.Bucket;
import com.google.gcloud.storage.BucketInfo;
import com.google.gcloud.storage.Storage;
import com.google.gcloud.storage.StorageFactory;
import com.google.gcloud.storage.StorageOptions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StorageExample {
    private static final Map<String, StorageAction> ACTIONS = new HashMap<String, StorageAction>();

    public static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, StorageAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param);
        }
        System.out.printf("Usage: %s [<project_id>] operation <args>*%s%n", StorageExample.class.getSimpleName(), actionAndParams);
    }

    public static void main(String ... args) throws Exception {
        Object request;
        StorageAction action;
        if (args.length < 1) {
            System.out.println("Missing required project id and action");
            StorageExample.printUsage();
            return;
        }
        StorageOptions.Builder optionsBuilder = (StorageOptions.Builder)StorageOptions.builder().retryParams(RetryParams.getDefaultInstance());
        if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
            optionsBuilder.projectId(args[0]);
            action = ACTIONS.get(args[1]);
            args = Arrays.copyOfRange(args, 2, args.length);
        } else {
            action = ACTIONS.get(args[0]);
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (action == null) {
            System.out.println("Unrecognized action.");
            StorageExample.printUsage();
            return;
        }
        Storage storage = StorageFactory.instance().get(optionsBuilder.build());
        try {
            request = action.parse(storage, args);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Invalid input for action '" + args[1] + "'");
            System.out.println("Expected: " + action.params());
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse request.");
            ex.printStackTrace();
            return;
        }
        action.run(storage, request);
    }

    static {
        ACTIONS.put("info", new InfoAction());
        ACTIONS.put("delete", new DeleteAction());
        ACTIONS.put("list", new ListAction());
        ACTIONS.put("upload", new UploadAction());
        ACTIONS.put("download", new DownloadAction());
        ACTIONS.put("cp", new CopyAction());
        ACTIONS.put("compose", new ComposeAction());
        ACTIONS.put("update_metadata", new UpdateMetadataAction());
        ACTIONS.put("sign_url", new SignUrlAction());
    }

    private static class SignUrlAction
    extends StorageAction<StorageRpc.Tuple<AuthCredentials.ServiceAccountAuthCredentials, Blob>> {
        private static final char[] PASSWORD = "notasecret".toCharArray();

        private SignUrlAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<AuthCredentials.ServiceAccountAuthCredentials, Blob> tuple) throws Exception {
            this.run(storage, (AuthCredentials.ServiceAccountAuthCredentials)tuple.x(), (Blob)tuple.y());
        }

        private void run(Storage storage, AuthCredentials.ServiceAccountAuthCredentials cred, Blob blob) throws IOException {
            System.out.println("Signed URL: " + blob.signUrl(1L, TimeUnit.DAYS, new Storage.SignUrlOption[]{Storage.SignUrlOption.serviceAccount((AuthCredentials.ServiceAccountAuthCredentials)cred)}));
        }

        @Override
        StorageRpc.Tuple<AuthCredentials.ServiceAccountAuthCredentials, Blob> parse(Storage storage, String ... args) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (args.length != 4) {
                throw new IllegalArgumentException();
            }
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(Files.newInputStream(Paths.get(args[0], new String[0]), new OpenOption[0]), PASSWORD);
            PrivateKey privateKey = (PrivateKey)keystore.getKey("privatekey", PASSWORD);
            AuthCredentials.ServiceAccountAuthCredentials cred = AuthCredentials.createFor((String)args[1], (PrivateKey)privateKey);
            return StorageRpc.Tuple.of((Object)cred, (Object)new Blob(storage, args[2], args[3]));
        }

        @Override
        public String params() {
            return "<service_account_private_key_file> <service_account_email> <bucket> <path>";
        }
    }

    private static class UpdateMetadataAction
    extends StorageAction<StorageRpc.Tuple<Blob, Map<String, String>>> {
        private UpdateMetadataAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<Blob, Map<String, String>> tuple) throws IOException {
            this.run(storage, (Blob)tuple.x(), (Map)tuple.y());
        }

        private void run(Storage storage, Blob blob, Map<String, String> metadata) {
            if (!(blob = blob.reload(new Blob.BlobSourceOption[0])).exists(new Blob.BlobSourceOption[0])) {
                System.out.println("No such object");
                return;
            }
            Blob updateBlob = blob.update(blob.info().toBuilder().metadata(metadata).build(), new Storage.BlobTargetOption[0]);
            System.out.println("Updated " + updateBlob.info());
        }

        @Override
        StorageRpc.Tuple<Blob, Map<String, String>> parse(Storage storage, String ... args) {
            if (args.length < 2) {
                throw new IllegalArgumentException();
            }
            Blob blob = new Blob(storage, args[0], args[1]);
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (int i = 2; i < args.length; ++i) {
                int idx = args[i].indexOf(61);
                if (idx < 0) {
                    metadata.put(args[i], "");
                    continue;
                }
                metadata.put(args[i].substring(0, idx), args[i].substring(idx + 1));
            }
            return StorageRpc.Tuple.of((Object)blob, metadata);
        }

        @Override
        public String params() {
            return "<bucket> <path> [local_file]";
        }
    }

    private static class ComposeAction
    extends StorageAction<Storage.ComposeRequest> {
        private ComposeAction() {
        }

        @Override
        public void run(Storage storage, Storage.ComposeRequest request) {
            BlobInfo composedBlobInfo = storage.compose(request);
            System.out.println("Composed " + composedBlobInfo);
        }

        @Override
        Storage.ComposeRequest parse(Storage storage, String ... args) {
            if (args.length < 3) {
                throw new IllegalArgumentException();
            }
            Storage.ComposeRequest.Builder request = Storage.ComposeRequest.builder();
            request.target(BlobInfo.builder((String)args[0], (String)args[args.length - 1]).build());
            for (int i = 1; i < args.length - 1; ++i) {
                request.addSource(new String[]{args[i]});
            }
            return request.build();
        }

        @Override
        public String params() {
            return "<bucket> <from_path>+ <to_path>";
        }
    }

    private static class CopyAction
    extends StorageAction<Storage.CopyRequest> {
        private CopyAction() {
        }

        @Override
        public void run(Storage storage, Storage.CopyRequest request) {
            BlobInfo copiedBlobInfo = storage.copy(request);
            System.out.println("Copied " + copiedBlobInfo);
        }

        @Override
        Storage.CopyRequest parse(Storage storage, String ... args) {
            if (args.length != 4) {
                throw new IllegalArgumentException();
            }
            return Storage.CopyRequest.of((String)args[0], (String)args[1], (BlobInfo)BlobInfo.builder((String)args[2], (String)args[3]).build());
        }

        @Override
        public String params() {
            return "<from_bucket> <from_path> <to_bucket> <to_path>";
        }
    }

    private static class DownloadAction
    extends StorageAction<StorageRpc.Tuple<Blob, Path>> {
        private DownloadAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<Blob, Path> tuple) throws IOException {
            this.run(storage, (Blob)tuple.x(), (Path)tuple.y());
        }

        private void run(Storage storage, Blob blob, Path downloadTo) throws IOException {
            if (!(blob = blob.reload(new Blob.BlobSourceOption[0])).exists(new Blob.BlobSourceOption[0])) {
                System.out.println("No such object");
                return;
            }
            PrintStream writeTo = System.out;
            if (downloadTo != null) {
                writeTo = new PrintStream(new FileOutputStream(downloadTo.toFile()));
            }
            if (blob.info().size() < 1000000L) {
                byte[] content = blob.content(new Storage.BlobSourceOption[0]);
                writeTo.write(content);
            } else {
                try (BlobReadChannel reader = blob.reader(new Blob.BlobSourceOption[0]);){
                    WritableByteChannel channel = Channels.newChannel(writeTo);
                    ByteBuffer bytes = ByteBuffer.allocate(65536);
                    while (reader.read(bytes) > 0) {
                        bytes.flip();
                        channel.write(bytes);
                        bytes.clear();
                    }
                }
            }
            if (downloadTo == null) {
                writeTo.println();
            } else {
                writeTo.close();
            }
        }

        @Override
        StorageRpc.Tuple<Blob, Path> parse(Storage storage, String ... args) {
            Path path;
            if (args.length < 2 || args.length > 3) {
                throw new IllegalArgumentException();
            }
            if (args.length > 2) {
                path = Paths.get(args[2], new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    path = path.resolve(Paths.get(args[1], new String[0]).getFileName());
                }
            } else {
                path = null;
            }
            return StorageRpc.Tuple.of((Object)new Blob(storage, args[0], args[1]), (Object)path);
        }

        @Override
        public String params() {
            return "<bucket> <path> [local_file]";
        }
    }

    private static class UploadAction
    extends StorageAction<StorageRpc.Tuple<Path, Blob>> {
        private UploadAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<Path, Blob> tuple) throws Exception {
            this.run(storage, (Path)tuple.x(), (Blob)tuple.y());
        }

        private void run(Storage storage, Path uploadFrom, Blob blob) throws IOException {
            block28: {
                if (Files.size(uploadFrom) > 1000000L) {
                    try (BlobWriteChannel writer = blob.writer(new Storage.BlobTargetOption[0]);){
                        byte[] buffer = new byte[1024];
                        try (InputStream input = Files.newInputStream(uploadFrom, new OpenOption[0]);){
                            int limit;
                            while ((limit = input.read(buffer)) >= 0) {
                                try {
                                    writer.write(ByteBuffer.wrap(buffer, 0, limit));
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            break block28;
                        }
                    }
                }
                byte[] bytes = Files.readAllBytes(uploadFrom);
                storage.create(blob.info(), bytes, new Storage.BlobTargetOption[0]);
            }
            System.out.println("Blob was created");
        }

        @Override
        StorageRpc.Tuple<Path, Blob> parse(Storage storage, String ... args) throws IOException {
            if (args.length < 2 || args.length > 3) {
                throw new IllegalArgumentException();
            }
            Path path = Paths.get(args[0], new String[0]);
            String contentType = Files.probeContentType(path);
            String blob = args.length < 3 ? path.getFileName().toString() : args[2];
            BlobInfo info = BlobInfo.builder((String)args[1], (String)blob).contentType(contentType).build();
            return StorageRpc.Tuple.of((Object)path, (Object)new Blob(storage, info));
        }

        @Override
        public String params() {
            return "<local_file> <bucket> [<path>]";
        }
    }

    private static class ListAction
    extends StorageAction<String> {
        private ListAction() {
        }

        @Override
        String parse(Storage storage, String ... args) {
            if (args.length == 0) {
                return null;
            }
            if (args.length == 1) {
                return args[0];
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void run(Storage storage, String bucketName) {
            if (bucketName == null) {
                for (BucketInfo b : storage.list(new Storage.BucketListOption[0])) {
                    System.out.println(b);
                }
            } else {
                Bucket bucket = new Bucket(storage, bucketName);
                for (Blob b : bucket.list(new Storage.BlobListOption[0])) {
                    System.out.println(b.info());
                }
            }
        }

        @Override
        public String params() {
            return "[<bucket>]";
        }
    }

    private static class DeleteAction
    extends BlobsAction {
        private DeleteAction() {
        }

        @Override
        public void run(Storage storage, Blob ... blobs) {
            if (blobs.length == 1) {
                boolean wasDeleted = blobs[0].delete(new Blob.BlobSourceOption[0]);
                if (wasDeleted) {
                    System.out.println("Blob " + blobs[0].info() + " was deleted");
                }
            } else {
                BatchRequest.Builder batch = BatchRequest.builder();
                for (Blob blob : blobs) {
                    batch.delete(blob.info().bucket(), blob.info().name(), new Storage.BlobSourceOption[0]);
                }
                int index = 0;
                BatchResponse response = storage.apply(batch.build());
                for (BatchResponse.Result result : response.deletes()) {
                    if (((Boolean)result.get()).booleanValue()) {
                        System.out.println("Blob " + blobs[index].info() + " was deleted");
                    }
                    ++index;
                }
            }
        }
    }

    private static class InfoAction
    extends BlobsAction {
        private InfoAction() {
        }

        @Override
        public void run(Storage storage, Blob ... blobs) {
            if (blobs.length == 1) {
                if (blobs[0].info().name().isEmpty()) {
                    Bucket bucket = new Bucket(storage, blobs[0].info().bucket());
                    System.out.println("Bucket info: " + bucket.reload(new Storage.BucketSourceOption[0]).info());
                } else {
                    System.out.println("Blob info: " + blobs[0].reload(new Blob.BlobSourceOption[0]).info());
                }
            } else {
                BatchRequest.Builder batch = BatchRequest.builder();
                for (Blob blob : blobs) {
                    batch.get(blob.info().bucket(), blob.info().name(), new Storage.BlobSourceOption[0]);
                }
                BatchResponse response = storage.apply(batch.build());
                for (BatchResponse.Result result : response.gets()) {
                    System.out.println(result.get());
                }
            }
        }

        @Override
        Blob[] parse(Storage storage, String ... args) {
            if (args.length < 2) {
                return new Blob[]{new Blob(storage, args[0], "")};
            }
            return super.parse(storage, args);
        }

        @Override
        public String params() {
            return "<bucket> [<path>+]";
        }
    }

    private static abstract class BlobsAction
    extends StorageAction<Blob[]> {
        private BlobsAction() {
        }

        @Override
        Blob[] parse(Storage storage, String ... args) {
            if (args.length < 2) {
                throw new IllegalArgumentException();
            }
            Blob[] blobs = new Blob[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                blobs[i - 1] = new Blob(storage, args[0], args[i]);
            }
            return blobs;
        }

        @Override
        public String params() {
            return "<bucket> <path>+";
        }
    }

    private static abstract class BlobAction
    extends StorageAction<Blob> {
        private BlobAction() {
        }

        @Override
        Blob parse(Storage storage, String ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            return new Blob(storage, args[0], args[1]);
        }

        @Override
        public String params() {
            return "<bucket> <path>";
        }
    }

    private static abstract class StorageAction<T> {
        private StorageAction() {
        }

        abstract void run(Storage var1, T var2) throws Exception;

        abstract T parse(Storage var1, String ... var2) throws Exception;

        protected String params() {
            return "";
        }
    }
}

