/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.examples;

import com.google.common.collect.ImmutableMap;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.BigQueryError;
import com.google.gcloud.bigquery.BigQueryOptions;
import com.google.gcloud.bigquery.CopyJobInfo;
import com.google.gcloud.bigquery.DatasetId;
import com.google.gcloud.bigquery.DatasetInfo;
import com.google.gcloud.bigquery.ExternalDataConfiguration;
import com.google.gcloud.bigquery.ExternalTableInfo;
import com.google.gcloud.bigquery.ExtractJobInfo;
import com.google.gcloud.bigquery.Field;
import com.google.gcloud.bigquery.FormatOptions;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.JobStatus;
import com.google.gcloud.bigquery.LoadJobInfo;
import com.google.gcloud.bigquery.QueryRequest;
import com.google.gcloud.bigquery.QueryResponse;
import com.google.gcloud.bigquery.Schema;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.bigquery.TableInfo;
import com.google.gcloud.bigquery.ViewInfo;
import com.google.gcloud.spi.BigQueryRpc;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BigQueryExample {
    private static final Map<String, BigQueryAction> CREATE_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> INFO_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> LIST_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> DELETE_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> ACTIONS = new HashMap<String, BigQueryAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, BigQueryAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param.replace("\n", "\n\t\t"));
        }
        System.out.printf("Usage: %s [<project_id>] operation [entity] <args>*%s%n", BigQueryExample.class.getSimpleName(), actionAndParams);
    }

    public static void main(String ... args) throws Exception {
        Object request;
        BigQueryAction action;
        String actionName;
        BigQueryOptions.Builder optionsBuilder = BigQueryOptions.builder();
        if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
            actionName = args[1];
            optionsBuilder.projectId(args[0]);
            action = ACTIONS.get(args[1]);
            args = Arrays.copyOfRange(args, 2, args.length);
        } else {
            actionName = args[0];
            action = ACTIONS.get(args[0]);
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (action == null) {
            System.out.println("Unrecognized action.");
            BigQueryExample.printUsage();
            return;
        }
        BigQuery bigquery = (BigQuery)optionsBuilder.build().service();
        try {
            request = action.parse(args);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Invalid input for action '" + actionName + "'");
            System.out.println("Expected: " + action.params());
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse request.");
            ex.printStackTrace();
            return;
        }
        action.run(bigquery, request);
    }

    static {
        CREATE_ACTIONS.put("dataset", new CreateDatasetAction());
        CREATE_ACTIONS.put("table", new CreateSimpleTableAction());
        CREATE_ACTIONS.put("view", new CreateViewAction());
        CREATE_ACTIONS.put("external-table", new CreateExternalTableAction());
        INFO_ACTIONS.put("dataset", new DatasetInfoAction());
        INFO_ACTIONS.put("table", new TableInfoAction());
        INFO_ACTIONS.put("job", new JobInfoAction());
        LIST_ACTIONS.put("datasets", new ListDatasetsAction());
        LIST_ACTIONS.put("tables", new ListTablesAction());
        LIST_ACTIONS.put("jobs", new ListJobsAction());
        LIST_ACTIONS.put("data", new ListTableDataAction());
        DELETE_ACTIONS.put("dataset", new DeleteDatasetAction());
        DELETE_ACTIONS.put("table", new DeleteTableAction());
        ACTIONS.put("create", new ParentAction(CREATE_ACTIONS));
        ACTIONS.put("info", new ParentAction(INFO_ACTIONS));
        ACTIONS.put("list", new ParentAction(LIST_ACTIONS));
        ACTIONS.put("delete", new ParentAction(DELETE_ACTIONS));
        ACTIONS.put("cancel", new CancelJobAction());
        ACTIONS.put("load", new LoadAction());
        ACTIONS.put("extract", new ExtractAction());
        ACTIONS.put("copy", new CopyAction());
        ACTIONS.put("query", new QueryAction());
    }

    private static class QueryAction
    extends BigQueryAction<QueryRequest> {
        private QueryAction() {
        }

        @Override
        void run(BigQuery bigquery, QueryRequest queryRequest) throws Exception {
            System.out.println("Running query");
            QueryResponse queryResponse = bigquery.query(queryRequest);
            while (!queryResponse.jobComplete()) {
                System.out.println("Waiting for query job " + queryResponse.jobId() + " to complete");
                Thread.sleep(1000L);
                queryResponse = bigquery.getQueryResults(queryResponse.jobId(), new BigQuery.QueryResultsOption[0]);
            }
            if (!queryResponse.hasErrors()) {
                System.out.println("Query succeeded. Results:");
                Iterator iterator = queryResponse.result().iterateAll();
                while (iterator.hasNext()) {
                    System.out.println(iterator.next());
                }
            } else {
                System.out.println("Query completed with errors. Errors:");
                for (BigQueryError err : queryResponse.executionErrors()) {
                    System.out.println(err);
                }
            }
        }

        @Override
        QueryRequest parse(String ... args) throws Exception {
            if (args.length == 1) {
                return QueryRequest.of((String)args[0]);
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected String params() {
            return "<query>";
        }
    }

    private static class CopyAction
    extends JobRunAction {
        private CopyAction() {
        }

        @Override
        CopyJobInfo parse(String ... args) throws Exception {
            if (args.length == 4) {
                TableId sourceTableId = TableId.of((String)args[0], (String)args[1]);
                TableId destinationTableId = TableId.of((String)args[2], (String)args[3]);
                return CopyJobInfo.of((TableId)destinationTableId, (TableId)sourceTableId);
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected String params() {
            return "<sourceDataset> <sourceTable> <destinationDataset> <destinationTable>";
        }
    }

    private static class ExtractAction
    extends JobRunAction {
        private ExtractAction() {
        }

        @Override
        ExtractJobInfo parse(String ... args) throws Exception {
            if (args.length >= 4) {
                String dataset = args[0];
                String table = args[1];
                String format = args[2];
                TableId tableId = TableId.of((String)dataset, (String)table);
                return ExtractJobInfo.builder((TableId)tableId, Arrays.asList(args).subList(3, args.length)).format(format).build();
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected String params() {
            return "<dataset> <table> <format> <destinationUri>+";
        }
    }

    private static class LoadAction
    extends JobRunAction {
        private LoadAction() {
        }

        @Override
        LoadJobInfo parse(String ... args) throws Exception {
            if (args.length >= 4) {
                String dataset = args[0];
                String table = args[1];
                String format = args[2];
                TableId tableId = TableId.of((String)dataset, (String)table);
                return LoadJobInfo.builder((TableId)tableId, Arrays.asList(args).subList(3, args.length)).formatOptions(FormatOptions.of((String)format)).build();
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected String params() {
            return "<dataset> <table> <format> <sourceUri>+";
        }
    }

    private static abstract class JobRunAction
    extends BigQueryAction<JobInfo> {
        private JobRunAction() {
        }

        @Override
        void run(BigQuery bigquery, JobInfo job) throws Exception {
            System.out.println("Creating job");
            JobInfo startedJob = bigquery.create(job, new BigQuery.JobOption[0]);
            while (startedJob.status().state() != JobStatus.State.DONE) {
                System.out.println("Waiting for job " + startedJob.jobId().job() + " to complete");
                Thread.sleep(1000L);
                startedJob = bigquery.getJob(startedJob.jobId(), new BigQuery.JobOption[0]);
            }
            if (startedJob.status().error() == null) {
                System.out.println("Job " + startedJob.jobId().job() + " suceeded");
            } else {
                System.out.println("Job " + startedJob.jobId().job() + " failed");
                System.out.println("Error: " + startedJob.status().error());
            }
        }
    }

    private static class CreateViewAction
    extends CreateTableAction {
        private CreateViewAction() {
        }

        @Override
        BaseTableInfo parse(String ... args) throws Exception {
            if (args.length == 3) {
                String dataset = args[0];
                String table = args[1];
                String query = args[2];
                TableId tableId = TableId.of((String)dataset, (String)table);
                return ViewInfo.of((TableId)tableId, (String)query);
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected String params() {
            return "<dataset> <table> <query>";
        }
    }

    private static class CreateExternalTableAction
    extends CreateTableAction {
        private CreateExternalTableAction() {
        }

        @Override
        BaseTableInfo parse(String ... args) throws Exception {
            if (args.length >= 5) {
                String dataset = args[0];
                String table = args[1];
                TableId tableId = TableId.of((String)dataset, (String)table);
                ExternalDataConfiguration configuration = ExternalDataConfiguration.of((String)args[args.length - 1], (Schema)CreateExternalTableAction.parseSchema(args, 3, args.length - 1), (FormatOptions)FormatOptions.of((String)args[2]));
                return ExternalTableInfo.of((TableId)tableId, (ExternalDataConfiguration)configuration);
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected String params() {
            return "<dataset> <table> <format> (<fieldName>:<primitiveType>)+ <sourceUri>";
        }
    }

    private static class CreateSimpleTableAction
    extends CreateTableAction {
        private CreateSimpleTableAction() {
        }

        @Override
        BaseTableInfo parse(String ... args) throws Exception {
            if (args.length >= 3) {
                String dataset = args[0];
                String table = args[1];
                TableId tableId = TableId.of((String)dataset, (String)table);
                return TableInfo.of((TableId)tableId, (Schema)CreateSimpleTableAction.parseSchema(args, 2, args.length));
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected String params() {
            return "<dataset> <table> (<fieldName>:<primitiveType>)+";
        }
    }

    private static abstract class CreateTableAction
    extends BigQueryAction<BaseTableInfo> {
        private CreateTableAction() {
        }

        @Override
        void run(BigQuery bigquery, BaseTableInfo table) throws Exception {
            BaseTableInfo createTable = bigquery.create(table, new BigQuery.TableOption[0]);
            System.out.println("Created table " + createTable.tableId());
            System.out.println(createTable.toString());
        }

        static Schema parseSchema(String[] args, int start, int end) {
            Schema.Builder builder = Schema.builder();
            for (int i = start; i < end; ++i) {
                Field.Type fieldType;
                String typeString;
                String[] fieldsArray = args[i].split(":");
                if (fieldsArray.length != 2) {
                    throw new IllegalArgumentException();
                }
                String fieldName = fieldsArray[0];
                switch (typeString = fieldsArray[1]) {
                    case "string": {
                        fieldType = Field.Type.string();
                        break;
                    }
                    case "integer": {
                        fieldType = Field.Type.integer();
                        break;
                    }
                    case "timestamp": {
                        fieldType = Field.Type.timestamp();
                        break;
                    }
                    case "float": {
                        fieldType = Field.Type.floatingPoint();
                        break;
                    }
                    case "boolean": {
                        fieldType = Field.Type.bool();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                builder.addField(Field.of((String)fieldName, (Field.Type)fieldType));
            }
            return builder.build();
        }
    }

    private static class CancelJobAction
    extends JobAction {
        private CancelJobAction() {
        }

        @Override
        public void run(BigQuery bigquery, JobId jobId) {
            bigquery.cancel(jobId);
            System.out.println("Requested cancel for job " + jobId);
        }
    }

    private static class JobInfoAction
    extends JobAction {
        private JobInfoAction() {
        }

        @Override
        public void run(BigQuery bigquery, JobId jobId) {
            System.out.println("Job info: " + bigquery.getJob(jobId, new BigQuery.JobOption[0]));
        }
    }

    private static class ListJobsAction
    extends VoidAction {
        private ListJobsAction() {
        }

        @Override
        public void run(BigQuery bigquery, Void arg) {
            Iterator datasetInfoIterator = bigquery.listJobs(new BigQuery.JobListOption[0]).iterateAll();
            while (datasetInfoIterator.hasNext()) {
                System.out.println(datasetInfoIterator.next());
            }
        }
    }

    private static abstract class JobAction
    extends BigQueryAction<JobId> {
        private JobAction() {
        }

        @Override
        JobId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return JobId.of((String)args[0]);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String params() {
            return "<job>";
        }
    }

    private static class ListTableDataAction
    extends TableAction {
        private ListTableDataAction() {
        }

        @Override
        public void run(BigQuery bigquery, TableId tableId) {
            Iterator iterator = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]).iterateAll();
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
        }
    }

    private static class DeleteTableAction
    extends TableAction {
        private DeleteTableAction() {
        }

        @Override
        public void run(BigQuery bigquery, TableId tableId) {
            bigquery.delete(tableId);
            System.out.println("Table " + tableId + " was deleted");
        }
    }

    private static class TableInfoAction
    extends TableAction {
        private TableInfoAction() {
        }

        @Override
        public void run(BigQuery bigquery, TableId tableId) {
            System.out.println("Table info: " + bigquery.getTable(tableId, new BigQuery.TableOption[0]));
        }
    }

    private static abstract class TableAction
    extends BigQueryAction<TableId> {
        private TableAction() {
        }

        @Override
        TableId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return TableId.of((String)args[0], (String)args[1]);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String params() {
            return "<dataset> <table>";
        }
    }

    private static class DeleteDatasetAction
    extends DatasetAction {
        private DeleteDatasetAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            bigquery.delete(datasetId, new BigQuery.DatasetDeleteOption[0]);
            System.out.println("Dataset " + datasetId + " was deleted");
        }
    }

    private static class CreateDatasetAction
    extends DatasetAction {
        private CreateDatasetAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            bigquery.create(DatasetInfo.builder((DatasetId)datasetId).build(), new BigQuery.DatasetOption[0]);
            System.out.println("Created dataset " + datasetId);
        }
    }

    private static class DatasetInfoAction
    extends DatasetAction {
        private DatasetInfoAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            System.out.println("Dataset info: " + bigquery.getDataset(datasetId, new BigQuery.DatasetOption[0]));
        }
    }

    private static class ListTablesAction
    extends DatasetAction {
        private ListTablesAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            Iterator tableInfoIterator = bigquery.listTables(datasetId, new BigQuery.TableListOption[0]).iterateAll();
            while (tableInfoIterator.hasNext()) {
                System.out.println(tableInfoIterator.next());
            }
        }
    }

    private static abstract class DatasetAction
    extends BigQueryAction<DatasetId> {
        private DatasetAction() {
        }

        @Override
        DatasetId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return DatasetId.of((String)args[0]);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String params() {
            return "<dataset>";
        }
    }

    private static class ListDatasetsAction
    extends VoidAction {
        private ListDatasetsAction() {
        }

        @Override
        public void run(BigQuery bigquery, Void arg) {
            Iterator datasetInfoIterator = bigquery.listDatasets(new BigQuery.DatasetListOption[0]).iterateAll();
            while (datasetInfoIterator.hasNext()) {
                System.out.println(datasetInfoIterator.next());
            }
        }
    }

    private static abstract class VoidAction
    extends BigQueryAction<Void> {
        private VoidAction() {
        }

        @Override
        Void parse(String ... args) throws Exception {
            if (args.length == 0) {
                return null;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class ParentAction
    extends BigQueryAction<BigQueryRpc.Tuple<BigQueryAction, Object>> {
        private final Map<String, BigQueryAction> subActions;

        public ParentAction(Map<String, BigQueryAction> subActions) {
            this.subActions = ImmutableMap.copyOf(subActions);
        }

        @Override
        void run(BigQuery bigquery, BigQueryRpc.Tuple<BigQueryAction, Object> subaction) throws Exception {
            ((BigQueryAction)subaction.x()).run(bigquery, subaction.y());
        }

        @Override
        BigQueryRpc.Tuple<BigQueryAction, Object> parse(String ... args) throws Exception {
            BigQueryAction action;
            if (args.length >= 1 && (action = this.subActions.get(args[0])) != null) {
                Object actionArguments = action.parse(Arrays.copyOfRange(args, 1, args.length));
                return BigQueryRpc.Tuple.of((Object)action, actionArguments);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String params() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, BigQueryAction> entry : this.subActions.entrySet()) {
                builder.append("\n").append(entry.getKey());
                String param = entry.getValue().params();
                if (param == null || param.isEmpty()) continue;
                builder.append(' ').append(param);
            }
            return builder.toString();
        }
    }

    private static abstract class BigQueryAction<T> {
        private BigQueryAction() {
        }

        abstract void run(BigQuery var1, T var2) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }
}

