/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.examples;

import com.google.gcloud.AuthCredentials;
import com.google.gcloud.RetryParams;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.Blob;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.BlobReadChannel;
import com.google.gcloud.storage.BlobWriteChannel;
import com.google.gcloud.storage.Bucket;
import com.google.gcloud.storage.CopyWriter;
import com.google.gcloud.storage.Storage;
import com.google.gcloud.storage.StorageOptions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StorageExample {
    private static final Map<String, StorageAction> ACTIONS = new HashMap<String, StorageAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, StorageAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param);
        }
        System.out.printf("Usage: %s [<project_id>] operation <args>*%s%n", StorageExample.class.getSimpleName(), actionAndParams);
    }

    public static void main(String ... args) throws Exception {
        Object request;
        StorageAction action;
        String actionName;
        if (args.length < 1) {
            System.out.println("Missing required project id and action");
            StorageExample.printUsage();
            return;
        }
        StorageOptions.Builder optionsBuilder = (StorageOptions.Builder)StorageOptions.builder().retryParams(RetryParams.defaultInstance());
        if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
            actionName = args[1];
            optionsBuilder.projectId(args[0]);
            action = ACTIONS.get(args[1]);
            args = Arrays.copyOfRange(args, 2, args.length);
        } else {
            actionName = args[0];
            action = ACTIONS.get(args[0]);
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (action == null) {
            System.out.println("Unrecognized action.");
            StorageExample.printUsage();
            return;
        }
        Storage storage = (Storage)optionsBuilder.build().service();
        try {
            request = action.parse(args);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Invalid input for action '" + actionName + "'");
            System.out.println("Expected: " + action.params());
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse request.");
            ex.printStackTrace();
            return;
        }
        action.run(storage, request);
    }

    static {
        ACTIONS.put("info", new InfoAction());
        ACTIONS.put("delete", new DeleteAction());
        ACTIONS.put("list", new ListAction());
        ACTIONS.put("upload", new UploadAction());
        ACTIONS.put("download", new DownloadAction());
        ACTIONS.put("cp", new CopyAction());
        ACTIONS.put("compose", new ComposeAction());
        ACTIONS.put("update_metadata", new UpdateMetadataAction());
        ACTIONS.put("sign_url", new SignUrlAction());
    }

    private static class SignUrlAction
    extends StorageAction<StorageRpc.Tuple<AuthCredentials.ServiceAccountAuthCredentials, BlobInfo>> {
        private static final char[] PASSWORD = "notasecret".toCharArray();

        private SignUrlAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<AuthCredentials.ServiceAccountAuthCredentials, BlobInfo> tuple) throws Exception {
            this.run(storage, (AuthCredentials.ServiceAccountAuthCredentials)tuple.x(), (BlobInfo)tuple.y());
        }

        private void run(Storage storage, AuthCredentials.ServiceAccountAuthCredentials cred, BlobInfo blobInfo) throws IOException {
            Blob blob = new Blob(storage, blobInfo);
            System.out.println("Signed URL: " + blob.signUrl(1L, TimeUnit.DAYS, new Storage.SignUrlOption[]{Storage.SignUrlOption.serviceAccount((AuthCredentials.ServiceAccountAuthCredentials)cred)}));
        }

        @Override
        StorageRpc.Tuple<AuthCredentials.ServiceAccountAuthCredentials, BlobInfo> parse(String ... args) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (args.length != 4) {
                throw new IllegalArgumentException();
            }
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(Files.newInputStream(Paths.get(args[0], new String[0]), new OpenOption[0]), PASSWORD);
            PrivateKey privateKey = (PrivateKey)keystore.getKey("privatekey", PASSWORD);
            AuthCredentials.ServiceAccountAuthCredentials cred = AuthCredentials.createFor((String)args[1], (PrivateKey)privateKey);
            return StorageRpc.Tuple.of((Object)cred, (Object)BlobInfo.builder((BlobId)BlobId.of((String)args[2], (String)args[3])).build());
        }

        @Override
        public String params() {
            return "<service_account_private_key_file> <service_account_email> <bucket> <path>";
        }
    }

    private static class UpdateMetadataAction
    extends StorageAction<StorageRpc.Tuple<BlobId, Map<String, String>>> {
        private UpdateMetadataAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<BlobId, Map<String, String>> tuple) throws IOException {
            this.run(storage, (BlobId)tuple.x(), (Map)tuple.y());
        }

        private void run(Storage storage, BlobId blobId, Map<String, String> metadata) {
            Blob blob = Blob.load((Storage)storage, (BlobId)blobId);
            if (blob == null) {
                System.out.println("No such object");
                return;
            }
            Blob updateBlob = blob.update(blob.info().toBuilder().metadata(metadata).build(), new Storage.BlobTargetOption[0]);
            System.out.println("Updated " + updateBlob.info());
        }

        @Override
        StorageRpc.Tuple<BlobId, Map<String, String>> parse(String ... args) {
            if (args.length < 2) {
                throw new IllegalArgumentException();
            }
            BlobId blobId = BlobId.of((String)args[0], (String)args[1]);
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (int i = 2; i < args.length; ++i) {
                int idx = args[i].indexOf(61);
                if (idx < 0) {
                    metadata.put(args[i], "");
                    continue;
                }
                metadata.put(args[i].substring(0, idx), args[i].substring(idx + 1));
            }
            return StorageRpc.Tuple.of((Object)blobId, metadata);
        }

        @Override
        public String params() {
            return "<bucket> <path> [local_file]";
        }
    }

    private static class ComposeAction
    extends StorageAction<Storage.ComposeRequest> {
        private ComposeAction() {
        }

        @Override
        public void run(Storage storage, Storage.ComposeRequest request) {
            BlobInfo composedBlobInfo = storage.compose(request);
            System.out.println("Composed " + composedBlobInfo);
        }

        @Override
        Storage.ComposeRequest parse(String ... args) {
            if (args.length < 3) {
                throw new IllegalArgumentException();
            }
            Storage.ComposeRequest.Builder request = Storage.ComposeRequest.builder();
            request.target(BlobInfo.builder((String)args[0], (String)args[args.length - 1]).build());
            for (int i = 1; i < args.length - 1; ++i) {
                request.addSource(new String[]{args[i]});
            }
            return request.build();
        }

        @Override
        public String params() {
            return "<bucket> <from_path>+ <to_path>";
        }
    }

    private static class CopyAction
    extends StorageAction<Storage.CopyRequest> {
        private CopyAction() {
        }

        @Override
        public void run(Storage storage, Storage.CopyRequest request) {
            CopyWriter copyWriter = storage.copy(request);
            System.out.println("Copied " + copyWriter.result());
        }

        @Override
        Storage.CopyRequest parse(String ... args) {
            if (args.length != 4) {
                throw new IllegalArgumentException();
            }
            return Storage.CopyRequest.of((String)args[0], (String)args[1], (BlobId)BlobId.of((String)args[2], (String)args[3]));
        }

        @Override
        public String params() {
            return "<from_bucket> <from_path> <to_bucket> <to_path>";
        }
    }

    private static class DownloadAction
    extends StorageAction<StorageRpc.Tuple<BlobId, Path>> {
        private DownloadAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<BlobId, Path> tuple) throws IOException {
            this.run(storage, (BlobId)tuple.x(), (Path)tuple.y());
        }

        private void run(Storage storage, BlobId blobId, Path downloadTo) throws IOException {
            Blob blob = Blob.load((Storage)storage, (BlobId)blobId);
            if (blob == null) {
                System.out.println("No such object");
                return;
            }
            PrintStream writeTo = System.out;
            if (downloadTo != null) {
                writeTo = new PrintStream(new FileOutputStream(downloadTo.toFile()));
            }
            if (blob.info().size() < 1000000L) {
                byte[] content = blob.content(new Storage.BlobSourceOption[0]);
                writeTo.write(content);
            } else {
                try (BlobReadChannel reader = blob.reader(new Blob.BlobSourceOption[0]);){
                    WritableByteChannel channel = Channels.newChannel(writeTo);
                    ByteBuffer bytes = ByteBuffer.allocate(65536);
                    while (reader.read(bytes) > 0) {
                        bytes.flip();
                        channel.write(bytes);
                        bytes.clear();
                    }
                }
            }
            if (downloadTo == null) {
                writeTo.println();
            } else {
                writeTo.close();
            }
        }

        @Override
        StorageRpc.Tuple<BlobId, Path> parse(String ... args) {
            Path path;
            if (args.length < 2 || args.length > 3) {
                throw new IllegalArgumentException();
            }
            if (args.length > 2) {
                path = Paths.get(args[2], new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    path = path.resolve(Paths.get(args[1], new String[0]).getFileName());
                }
            } else {
                path = null;
            }
            return StorageRpc.Tuple.of((Object)BlobId.of((String)args[0], (String)args[1]), (Object)path);
        }

        @Override
        public String params() {
            return "<bucket> <path> [local_file]";
        }
    }

    private static class UploadAction
    extends StorageAction<StorageRpc.Tuple<Path, BlobInfo>> {
        private UploadAction() {
        }

        @Override
        public void run(Storage storage, StorageRpc.Tuple<Path, BlobInfo> tuple) throws Exception {
            this.run(storage, (Path)tuple.x(), (BlobInfo)tuple.y());
        }

        private void run(Storage storage, Path uploadFrom, BlobInfo blobInfo) throws IOException {
            block28: {
                if (Files.size(uploadFrom) > 1000000L) {
                    Blob blob = new Blob(storage, blobInfo);
                    try (BlobWriteChannel writer = blob.writer(new Storage.BlobWriteOption[0]);){
                        byte[] buffer = new byte[1024];
                        try (InputStream input = Files.newInputStream(uploadFrom, new OpenOption[0]);){
                            int limit;
                            while ((limit = input.read(buffer)) >= 0) {
                                try {
                                    writer.write(ByteBuffer.wrap(buffer, 0, limit));
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            break block28;
                        }
                    }
                }
                byte[] bytes = Files.readAllBytes(uploadFrom);
                storage.create(blobInfo, bytes, new Storage.BlobTargetOption[0]);
            }
            System.out.println("Blob was created");
        }

        @Override
        StorageRpc.Tuple<Path, BlobInfo> parse(String ... args) throws IOException {
            if (args.length < 2 || args.length > 3) {
                throw new IllegalArgumentException();
            }
            Path path = Paths.get(args[0], new String[0]);
            String contentType = Files.probeContentType(path);
            String blob = args.length < 3 ? path.getFileName().toString() : args[2];
            return StorageRpc.Tuple.of((Object)path, (Object)BlobInfo.builder((String)args[1], (String)blob).contentType(contentType).build());
        }

        @Override
        public String params() {
            return "<local_file> <bucket> [<path>]";
        }
    }

    private static class ListAction
    extends StorageAction<String> {
        private ListAction() {
        }

        @Override
        String parse(String ... args) {
            if (args.length == 0) {
                return null;
            }
            if (args.length == 1) {
                return args[0];
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void run(Storage storage, String bucketName) {
            if (bucketName == null) {
                Iterator bucketInfoIterator = storage.list(new Storage.BucketListOption[0]).iterateAll();
                while (bucketInfoIterator.hasNext()) {
                    System.out.println(bucketInfoIterator.next());
                }
            } else {
                Bucket bucket = Bucket.load((Storage)storage, (String)bucketName);
                if (bucket == null) {
                    System.out.println("No such bucket");
                    return;
                }
                Iterator blobIterator = bucket.list(new Storage.BlobListOption[0]).iterateAll();
                while (blobIterator.hasNext()) {
                    System.out.println(((Blob)blobIterator.next()).info());
                }
            }
        }

        @Override
        public String params() {
            return "[<bucket>]";
        }
    }

    private static class DeleteAction
    extends BlobsAction {
        private DeleteAction() {
        }

        @Override
        public void run(Storage storage, BlobId ... blobIds) {
            List deleteResults = Blob.delete((Storage)storage, (BlobId[])blobIds);
            int index = 0;
            for (Boolean deleted : deleteResults) {
                if (deleted.booleanValue()) {
                    System.out.println("Blob " + blobIds[index] + " was deleted");
                }
                ++index;
            }
        }
    }

    private static class InfoAction
    extends BlobsAction {
        private InfoAction() {
        }

        @Override
        public void run(Storage storage, BlobId ... blobIds) {
            if (blobIds.length == 1) {
                if (blobIds[0].name().isEmpty()) {
                    Bucket bucket = Bucket.load((Storage)storage, (String)blobIds[0].bucket());
                    if (bucket == null) {
                        System.out.println("No such bucket");
                        return;
                    }
                    System.out.println("Bucket info: " + bucket.info());
                } else {
                    Blob blob = Blob.load((Storage)storage, (BlobId)blobIds[0]);
                    if (blob == null) {
                        System.out.println("No such object");
                        return;
                    }
                    System.out.println("Blob info: " + blob.info());
                }
            } else {
                List blobs = Blob.get((Storage)storage, (BlobId[])blobIds);
                for (Blob blob : blobs) {
                    if (blob == null) continue;
                    System.out.println(blob.info());
                }
            }
        }

        @Override
        BlobId[] parse(String ... args) {
            if (args.length < 2) {
                return new BlobId[]{BlobId.of((String)args[0], (String)"")};
            }
            return super.parse(args);
        }

        @Override
        public String params() {
            return "<bucket> [<path>+]";
        }
    }

    private static abstract class BlobsAction
    extends StorageAction<BlobId[]> {
        private BlobsAction() {
        }

        @Override
        BlobId[] parse(String ... args) {
            if (args.length < 2) {
                throw new IllegalArgumentException();
            }
            BlobId[] blobs = new BlobId[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                blobs[i - 1] = BlobId.of((String)args[0], (String)args[i]);
            }
            return blobs;
        }

        @Override
        public String params() {
            return "<bucket> <path>+";
        }
    }

    private static abstract class StorageAction<T> {
        private StorageAction() {
        }

        abstract void run(Storage var1, T var2) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }
}

