/*
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * EDITING INSTRUCTIONS
 * This file is referenced in READMEs and javadoc. Any change to this file should be reflected in
 * the project's READMEs and package-info.java.
 */

package com.google.gcloud.examples.datastore.snippets;

import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreOptions;
import com.google.gcloud.datastore.DateTime;
import com.google.gcloud.datastore.Entity;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.KeyFactory;

/**
 * A snippet for Google Cloud Datastore showing how to create an entity.
 */
public class CreateEntity {

  public static void main(String... args) {
    Datastore datastore = DatastoreOptions.defaultInstance().service();
    KeyFactory keyFactory = datastore.newKeyFactory().kind("keyKind");
    Key key = keyFactory.newKey("keyName");
    Entity entity = Entity.builder(key)
        .set("name", "John Doe")
        .set("age", 30)
        .set("access_time", DateTime.now())
        .build();
    datastore.put(entity);
  }
}
