/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.examples.bigquery.snippets;

import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.BigQueryOptions;
import com.google.gcloud.bigquery.Field;
import com.google.gcloud.bigquery.FormatOptions;
import com.google.gcloud.bigquery.Job;
import com.google.gcloud.bigquery.Schema;
import com.google.gcloud.bigquery.StandardTableDefinition;
import com.google.gcloud.bigquery.Table;
import com.google.gcloud.bigquery.TableDefinition;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.bigquery.TableInfo;

public class CreateTableAndLoadData {
    public static void main(String ... args) throws InterruptedException {
        TableId tableId;
        BigQuery bigquery = (BigQuery)BigQueryOptions.defaultInstance().service();
        Table table = bigquery.getTable(tableId = TableId.of((String)"dataset", (String)"table"), new BigQuery.TableOption[0]);
        if (table == null) {
            System.out.println("Creating table " + tableId);
            Field integerField = Field.of((String)"fieldName", (Field.Type)Field.Type.integer());
            Schema schema = Schema.of((Field[])new Field[]{integerField});
            table = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)schema)), new BigQuery.TableOption[0]);
        }
        System.out.println("Loading data into table " + tableId);
        Job loadJob = table.load((FormatOptions)FormatOptions.csv(), "gs://bucket/path", new BigQuery.JobOption[0]);
        while (!loadJob.isDone()) {
            Thread.sleep(1000L);
        }
        if (loadJob.status().error() != null) {
            System.out.println("Job completed with errors");
        } else {
            System.out.println("Job succeeded");
        }
    }
}

