/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.examples.dns.snippets;

import com.google.gcloud.dns.ChangeRequestInfo;
import com.google.gcloud.dns.Dns;
import com.google.gcloud.dns.DnsOptions;
import com.google.gcloud.dns.RecordSet;
import com.google.gcloud.dns.Zone;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class CreateOrUpdateRecordSets {
    public static void main(String ... args) {
        Dns dns = (Dns)DnsOptions.defaultInstance().service();
        String zoneName = "my-unique-zone";
        Zone zone = dns.getZone(zoneName, new Dns.ZoneOption[0]);
        String ip = "12.13.14.15";
        RecordSet toCreate = RecordSet.builder((String)("www." + zone.dnsName()), (RecordSet.Type)RecordSet.Type.A).ttl(24, TimeUnit.HOURS).addRecord(ip).build();
        ChangeRequestInfo.Builder changeBuilder = ChangeRequestInfo.builder().add(toCreate);
        Iterator recordSetIterator = zone.listRecordSets(new Dns.RecordSetListOption[0]).iterateAll();
        while (recordSetIterator.hasNext()) {
            RecordSet current = (RecordSet)recordSetIterator.next();
            if (!toCreate.name().equals(current.name()) || !toCreate.type().equals((Object)current.type())) continue;
            changeBuilder.delete(current);
        }
        ChangeRequestInfo changeRequest = changeBuilder.build();
        zone.applyChangeRequest(changeRequest, new Dns.ChangeRequestOption[0]);
    }
}

