/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.examples.dns.snippets;

import com.google.gcloud.dns.ChangeRequestInfo;
import com.google.gcloud.dns.Dns;
import com.google.gcloud.dns.DnsOptions;
import com.google.gcloud.dns.RecordSet;
import java.util.Iterator;

public class DeleteZone {
    public static void main(String ... args) {
        boolean result;
        Dns dns = (Dns)DnsOptions.defaultInstance().service();
        String zoneName = "my-unique-zone";
        Iterator recordIterator = dns.listRecordSets(zoneName, new Dns.RecordSetListOption[0]).iterateAll();
        ChangeRequestInfo.Builder changeBuilder = ChangeRequestInfo.builder();
        while (recordIterator.hasNext()) {
            RecordSet current = (RecordSet)recordIterator.next();
            if (RecordSet.Type.SOA.equals((Object)current.type()) || RecordSet.Type.NS.equals((Object)current.type())) continue;
            changeBuilder.delete(current);
        }
        ChangeRequestInfo changeRequest = changeBuilder.build();
        if (!changeRequest.deletions().isEmpty()) {
            changeRequest = dns.applyChangeRequest(zoneName, changeRequest, new Dns.ChangeRequestOption[0]);
            Dns.ChangeRequestOption option = Dns.ChangeRequestOption.fields((Dns.ChangeRequestField[])new Dns.ChangeRequestField[]{Dns.ChangeRequestField.STATUS});
            while (ChangeRequestInfo.Status.PENDING.equals((Object)changeRequest.status())) {
                System.out.println("Waiting for change to complete. Going to sleep for 500ms...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    System.err.println("The thread was interrupted while waiting for change request to be processed.");
                }
                changeRequest = dns.getChangeRequest(zoneName, changeRequest.id(), new Dns.ChangeRequestOption[]{option});
            }
        }
        if (result = dns.delete(zoneName)) {
            System.out.println("Zone was deleted.");
        } else {
            System.out.println("Zone was not deleted because it does not exist.");
        }
    }
}

