/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.annotations.SeekBarProgressChange;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.IdValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

public class SeekBarProgressChangeValidator
implements ElementValidator {
    private final IdValidatorHelper validatorHelper;
    private final IdAnnotationHelper annotationHelper;

    public SeekBarProgressChangeValidator(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.validatorHelper = new IdValidatorHelper(this.annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return SeekBarProgressChange.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.hasProgressChangeMethodParameters(executableElement, valid);
        return valid.isValid();
    }

    private void hasProgressChangeMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean seekBarParameterFound = false;
        boolean fromUserParameterFound = false;
        boolean progressParameterFound = false;
        for (VariableElement variableElement : parameters) {
            String parameterType = ((Object)variableElement.asType()).toString();
            if (parameterType.equals("android.widget.SeekBar")) {
                if (seekBarParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. You can declare only one parameter of type android.widget.SeekBar");
                    valid.invalidate();
                }
                seekBarParameterFound = true;
                continue;
            }
            if (variableElement.asType().getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType)) {
                if (progressParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "You can have only one parameter of type " + CanonicalNameConstants.INTEGER);
                    valid.invalidate();
                }
                progressParameterFound = true;
                continue;
            }
            if (variableElement.asType().getKind() == TypeKind.BOOLEAN || CanonicalNameConstants.BOOLEAN.equals(parameterType)) {
                if (fromUserParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "You can have only one parameter of type " + CanonicalNameConstants.BOOLEAN);
                    valid.invalidate();
                }
                fromUserParameterFound = true;
                continue;
            }
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter '" + variableElement.toString() + "'. %s signature should be " + executableElement.getSimpleName() + "(" + "android.widget.SeekBar" + " seekBar, int progress, boolean fromUser). The 'fromUser' and 'progress' parameters are optional.");
            valid.invalidate();
        }
    }
}

