/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;

public class EBeansHolder {
    private final Map<Element, EBeanHolder> eBeanHolders = new HashMap<Element, EBeanHolder>();
    private final JCodeModel codeModel;
    private final Map<String, JClass> loadedClasses = new HashMap<String, JClass>();
    private final Classes classes;
    private final Map<String, Element> originatingElementsByGeneratedClassQualifiedName = new HashMap<String, Element>();

    public EBeansHolder(JCodeModel codeModel) {
        this.codeModel = codeModel;
        this.classes = new Classes();
        this.refClass(CanonicalNameConstants.STRING);
        this.preloadJavaLangClasses();
    }

    private void preloadJavaLangClasses() {
        this.loadedClasses.put(String.class.getName(), this.refClass(String.class));
        this.loadedClasses.put(Object.class.getName(), this.refClass(Object.class));
    }

    public EBeanHolder create(Element element, Class<? extends Annotation> eBeanAnnotation, JDefinedClass generatedClass) {
        String qualifiedName = generatedClass.fullName();
        this.originatingElementsByGeneratedClassQualifiedName.put(qualifiedName, element);
        EBeanHolder activityHolder = new EBeanHolder(this, eBeanAnnotation, generatedClass);
        this.eBeanHolders.put(element, activityHolder);
        return activityHolder;
    }

    public EBeanHolder getEBeanHolder(Element element) {
        return this.eBeanHolders.get(element);
    }

    public JClass refClass(String fullyQualifiedClassName) {
        int arrayCounter = 0;
        while (fullyQualifiedClassName.endsWith("[]")) {
            ++arrayCounter;
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, fullyQualifiedClassName.length() - 2);
        }
        JClass refClass = this.loadedClasses.get(fullyQualifiedClassName);
        if (refClass == null) {
            refClass = this.codeModel.directClass(fullyQualifiedClassName);
            this.loadedClasses.put(fullyQualifiedClassName, refClass);
        }
        for (int i = 0; i < arrayCounter; ++i) {
            refClass = refClass.array();
        }
        return refClass;
    }

    public JClass refClass(Class<?> clazz) {
        return this.codeModel.ref(clazz);
    }

    public JCodeModel codeModel() {
        return this.codeModel;
    }

    public Classes classes() {
        return this.classes;
    }

    public Map<String, Element> getOriginatingElementsByGeneratedClassQualifiedName() {
        return this.originatingElementsByGeneratedClassQualifiedName;
    }

    public class Classes {
        public final JClass RUNTIME_EXCEPTION;
        public final JClass EXCEPTION;
        public final JClass CHAR_SEQUENCE;
        public final JClass CLASS_CAST_EXCEPTION;
        public final JClass SERIALIZABLE;
        public final JClass STRING;
        public final JClass SYSTEM;
        public final JClass INPUT_STREAM;
        public final JClass FILE_INPUT_STREAM;
        public final JClass SQL_EXCEPTION;
        public final JClass LOG;
        public final JClass BUNDLE;
        public final JClass ACTIVITY;
        public final JClass EDITABLE;
        public final JClass TEXT_WATCHER;
        public final JClass SEEKBAR;
        public final JClass ON_SEEKBAR_CHANGE_LISTENER;
        public final JClass TEXT_VIEW;
        public final JClass VIEW;
        public final JClass VIEW_ON_CLICK_LISTENER;
        public final JClass VIEW_GROUP_LAYOUT_PARAMS;
        public final JClass KEY_EVENT;
        public final JClass CONTEXT;
        public final JClass INTENT;
        public final JClass VIEW_GROUP;
        public final JClass LAYOUT_INFLATER;
        public final JClass FRAGMENT_ACTIVITY;
        public final JClass FRAGMENT;
        public final JClass SUPPORT_V4_FRAGMENT;
        public final JClass HTML;
        public final JClass WINDOW_MANAGER_LAYOUT_PARAMS;
        public final JClass ADAPTER_VIEW;
        public final JClass ON_ITEM_LONG_CLICK_LISTENER;
        public final JClass ON_ITEM_CLICK_LISTENER;
        public final JClass ON_ITEM_SELECTED_LISTENER;
        public final JClass ON_LONG_CLICK_LISTENER;
        public final JClass WINDOW;
        public final JClass MENU_ITEM;
        public final JClass MENU_INFLATER;
        public final JClass MENU;
        public final JClass ANIMATION_UTILS;
        public final JClass RESOURCES;
        public final JClass CONFIGURATION;
        public final JClass MOTION_EVENT;
        public final JClass ON_TOUCH_LISTENER;
        public final JClass HANDLER;
        public final JClass KEY_STORE;
        public final JClass SHERLOCK_MENU;
        public final JClass SHERLOCK_MENU_ITEM;
        public final JClass SHERLOCK_MENU_INFLATER;
        public final JClass INJECTOR_PROVIDER;
        public final JClass INJECTOR;
        public final JClass ON_RESTART_EVENT;
        public final JClass ON_START_EVENT;
        public final JClass ON_RESUME_EVENT;
        public final JClass ON_PAUSE_EVENT;
        public final JClass ON_NEW_INTENT_EVENT;
        public final JClass EVENT_MANAGER;
        public final JClass CONTEXT_SCOPE;
        public final JClass INJECT;
        public final JClass ON_STOP_EVENT;
        public final JClass ON_DESTROY_EVENT;
        public final JClass ON_CONFIGURATION_CHANGED_EVENT;
        public final JClass ON_CONTENT_CHANGED_EVENT;
        public final JClass ON_ACTIVITY_RESULT_EVENT;
        public final JClass ON_CONTENT_VIEW_AVAILABLE_EVENT;
        public final JClass ON_CREATE_EVENT;
        public final JClass CONNECTION_SOURCE;
        public final JClass OPEN_HELPER_MANAGER;
        public final JClass DAO_MANAGER;
        public final JClass CLIENT_CONNECTION_MANAGER;
        public final JClass DEFAULT_HTTP_CLIENT;
        public final JClass SSL_SOCKET_FACTORY;
        public final JClass SCHEME;
        public final JClass SCHEME_REGISTRY;
        public final JClass SINGLE_CLIENT_CONN_MANAGER;

        public Classes() {
            this.RUNTIME_EXCEPTION = EBeansHolder.this.refClass(RuntimeException.class);
            this.EXCEPTION = EBeansHolder.this.refClass(Exception.class);
            this.CHAR_SEQUENCE = EBeansHolder.this.refClass(CharSequence.class);
            this.CLASS_CAST_EXCEPTION = EBeansHolder.this.refClass(ClassCastException.class);
            this.SERIALIZABLE = EBeansHolder.this.refClass(Serializable.class);
            this.STRING = EBeansHolder.this.refClass(String.class);
            this.SYSTEM = EBeansHolder.this.refClass(System.class);
            this.INPUT_STREAM = EBeansHolder.this.refClass(InputStream.class);
            this.FILE_INPUT_STREAM = EBeansHolder.this.refClass(FileInputStream.class);
            this.SQL_EXCEPTION = EBeansHolder.this.refClass(SQLException.class);
            this.LOG = EBeansHolder.this.refClass("android.util.Log");
            this.BUNDLE = EBeansHolder.this.refClass("android.os.Bundle");
            this.ACTIVITY = EBeansHolder.this.refClass("android.app.Activity");
            this.EDITABLE = EBeansHolder.this.refClass("android.text.Editable");
            this.TEXT_WATCHER = EBeansHolder.this.refClass("android.text.TextWatcher");
            this.SEEKBAR = EBeansHolder.this.refClass("android.widget.SeekBar");
            this.ON_SEEKBAR_CHANGE_LISTENER = EBeansHolder.this.refClass("android.widget.SeekBar.OnSeekBarChangeListener");
            this.TEXT_VIEW = EBeansHolder.this.refClass("android.widget.TextView");
            this.VIEW = EBeansHolder.this.refClass("android.view.View");
            this.VIEW_ON_CLICK_LISTENER = EBeansHolder.this.refClass("android.view.View.OnClickListener");
            this.VIEW_GROUP_LAYOUT_PARAMS = EBeansHolder.this.refClass("android.view.ViewGroup.LayoutParams");
            this.KEY_EVENT = EBeansHolder.this.refClass("android.view.KeyEvent");
            this.CONTEXT = EBeansHolder.this.refClass("android.content.Context");
            this.INTENT = EBeansHolder.this.refClass("android.content.Intent");
            this.VIEW_GROUP = EBeansHolder.this.refClass("android.view.ViewGroup");
            this.LAYOUT_INFLATER = EBeansHolder.this.refClass("android.view.LayoutInflater");
            this.FRAGMENT_ACTIVITY = EBeansHolder.this.refClass("android.support.v4.app.FragmentActivity");
            this.FRAGMENT = EBeansHolder.this.refClass("android.app.Fragment");
            this.SUPPORT_V4_FRAGMENT = EBeansHolder.this.refClass("android.support.v4.app.Fragment");
            this.HTML = EBeansHolder.this.refClass("android.text.Html");
            this.WINDOW_MANAGER_LAYOUT_PARAMS = EBeansHolder.this.refClass("android.view.WindowManager.LayoutParams");
            this.ADAPTER_VIEW = EBeansHolder.this.refClass("android.widget.AdapterView");
            this.ON_ITEM_LONG_CLICK_LISTENER = EBeansHolder.this.refClass("android.widget.AdapterView.OnItemLongClickListener");
            this.ON_ITEM_CLICK_LISTENER = EBeansHolder.this.refClass("android.widget.AdapterView.OnItemClickListener");
            this.ON_ITEM_SELECTED_LISTENER = EBeansHolder.this.refClass("android.widget.AdapterView.OnItemSelectedListener");
            this.ON_LONG_CLICK_LISTENER = EBeansHolder.this.refClass("android.view.View.OnLongClickListener");
            this.WINDOW = EBeansHolder.this.refClass("android.view.Window");
            this.MENU_ITEM = EBeansHolder.this.refClass("android.view.MenuItem");
            this.MENU_INFLATER = EBeansHolder.this.refClass("android.view.MenuInflater");
            this.MENU = EBeansHolder.this.refClass("android.view.Menu");
            this.ANIMATION_UTILS = EBeansHolder.this.refClass("android.view.animation.AnimationUtils");
            this.RESOURCES = EBeansHolder.this.refClass("android.content.res.Resources");
            this.CONFIGURATION = EBeansHolder.this.refClass("android.content.res.Configuration");
            this.MOTION_EVENT = EBeansHolder.this.refClass("android.view.MotionEvent");
            this.ON_TOUCH_LISTENER = EBeansHolder.this.refClass("android.view.View.OnTouchListener");
            this.HANDLER = EBeansHolder.this.refClass("android.os.Handler");
            this.KEY_STORE = EBeansHolder.this.refClass("java.security.KeyStore");
            this.SHERLOCK_MENU = EBeansHolder.this.refClass("com.actionbarsherlock.view.Menu");
            this.SHERLOCK_MENU_ITEM = EBeansHolder.this.refClass("com.actionbarsherlock.view.MenuItem");
            this.SHERLOCK_MENU_INFLATER = EBeansHolder.this.refClass("com.actionbarsherlock.view.MenuInflater");
            this.INJECTOR_PROVIDER = EBeansHolder.this.refClass("roboguice.inject.InjectorProvider");
            this.INJECTOR = EBeansHolder.this.refClass("com.google.inject.Injector");
            this.ON_RESTART_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnRestartEvent");
            this.ON_START_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnStartEvent");
            this.ON_RESUME_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnResumeEvent");
            this.ON_PAUSE_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnPauseEvent");
            this.ON_NEW_INTENT_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnNewIntentEvent");
            this.EVENT_MANAGER = EBeansHolder.this.refClass("roboguice.event.EventManager");
            this.CONTEXT_SCOPE = EBeansHolder.this.refClass("roboguice.inject.ContextScope");
            this.INJECT = EBeansHolder.this.refClass("com.google.inject.Inject");
            this.ON_STOP_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnStopEvent");
            this.ON_DESTROY_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnDestroyEvent");
            this.ON_CONFIGURATION_CHANGED_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnConfigurationChangedEvent");
            this.ON_CONTENT_CHANGED_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnContentChangedEvent");
            this.ON_ACTIVITY_RESULT_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnActivityResultEvent");
            this.ON_CONTENT_VIEW_AVAILABLE_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnContentViewAvailableEvent");
            this.ON_CREATE_EVENT = EBeansHolder.this.refClass("roboguice.activity.event.OnCreateEvent");
            this.CONNECTION_SOURCE = EBeansHolder.this.refClass("com.j256.ormlite.support.ConnectionSource");
            this.OPEN_HELPER_MANAGER = EBeansHolder.this.refClass("com.j256.ormlite.android.apptools.OpenHelperManager");
            this.DAO_MANAGER = EBeansHolder.this.refClass("com.j256.ormlite.dao.DaoManager");
            this.CLIENT_CONNECTION_MANAGER = EBeansHolder.this.refClass("org.apache.http.conn.ClientConnectionManager");
            this.DEFAULT_HTTP_CLIENT = EBeansHolder.this.refClass("org.apache.http.impl.client.DefaultHttpClient");
            this.SSL_SOCKET_FACTORY = EBeansHolder.this.refClass("org.apache.http.conn.ssl.SSLSocketFactory");
            this.SCHEME = EBeansHolder.this.refClass("org.apache.http.conn.scheme.Scheme");
            this.SCHEME_REGISTRY = EBeansHolder.this.refClass("org.apache.http.conn.scheme.SchemeRegistry");
            this.SINGLE_CLIENT_CONN_MANAGER = EBeansHolder.this.refClass("org.apache.http.impl.conn.SingleClientConnManager");
        }
    }
}

